<?php
// ===============================
// AMBIL DATA HASIL KERJA
// ===============================
$query  = "SELECT * FROM tb_hasil_kerja";
$result = $conn->query($query);
?>

<!-- =============================== -->
<!-- CONTENT WRAPPER -->
<!-- =============================== -->
<div class="content-wrapper">
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">

                    <div class="card mt-3">
                        <div class="card-header d-flex align-items-center">
                            <h4 class="flex-grow-1 m-0 font-weight-bold">
                                Data Hasil Kerja
                            </h4>
                            <a href="?page=tambah_hasil_kerja" class="btn btn-primary">
                                Tambah
                            </a>
                        </div>

                        <!-- =============================== -->
                        <!-- STYLE PENGAMAN -->
                        <!-- =============================== -->
                        <style>
                            /* MATIKAN SEMUA EMBED DI DALAM TABEL */
                            table iframe,
                            table embed,
                            table object,
                            table video {
                                display: none !important;
                            }

                            /* RAPIKAN LINK */
                            .yt-link {
                                word-break: break-all;
                                color: #0d6efd;
                                font-weight: 500;
                            }

                            .aksi-btn .btn {
                                margin-bottom: 4px;
                            }
                        </style>

                        <!-- =============================== -->
                        <!-- CARD BODY -->
                        <!-- =============================== -->
                        <div class="card-body">

                            <table id="example2" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="50" class="text-center">No</th>
                                        <th>Link YouTube</th>
                                        <th width="220" class="text-center">Aksi</th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php
                                    $no = 1;
                                    while ($row = $result->fetch_assoc()) :

                                        // ===============================
                                        // BERSIHKAN DATA (KUNCI MASALAH)
                                        // ===============================
                                        $link_bersih = strip_tags($row['link_yt']); // hancurkan iframe
                                        $link_bersih = trim($link_bersih);
                                        $link_safe   = htmlspecialchars($link_bersih, ENT_QUOTES, 'UTF-8');
                                    ?>
                                        <tr>
                                            <td class="text-center"><?= $no++ ?></td>

                                            <!-- LINK AMAN -->
                                            <td>
                                                <?php if ($link_safe != '') : ?>
                                                    <a href="<?= $link_safe ?>"
                                                       target="_blank"
                                                       class="yt-link">
                                                        <?= $link_safe ?>
                                                    </a>
                                                <?php else : ?>
                                                    <span class="text-muted">Tidak ada link</span>
                                                <?php endif; ?>
                                            </td>

                                            <!-- AKSI -->
                                            <td class="text-center aksi-btn">
                                                <?php if ($link_safe != '') : ?>
                                                    <a href="<?= $link_safe ?>"
                                                       target="_blank"
                                                       class="btn btn-sm btn-success">
                                                        ▶ Lihat
                                                    </a>
                                                <?php endif; ?>

                                                <a href="?page=edit_hasil_kerja&id=<?= $row['id'] ?>"
                                                   class="btn btn-sm btn-warning">
                                                    Edit
                                                </a>

                                                <form action="?page=hapus_hasil_kerja&id=<?= $row['id'] ?>"
                                                      method="POST"
                                                      class="d-inline">
                                                    <button type="submit"
                                                            class="btn btn-sm btn-danger"
                                                            onclick="return confirm('Yakin hapus data ini?')">
                                                        Hapus
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>

                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->

                </div>
            </div>

        </div>
    </section>
</div>

<!-- =============================== -->
<!-- DATATABLES -->
<!-- =============================== -->
<script>
$(function () {
    $('#example2').DataTable({
        paging: true,
        searching: true,
        ordering: true,
        info: true,
        responsive: true,
        autoWidth: false
    });
});
</script>
