<?php
session_start();
session_destroy();
?>
<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <title>Najwa Record</title>

    <style>
        /* Tambahan untuk background video */
        .bg-video {
            position: fixed;
            top: 0;
            left: 0;
            min-width: 100%;
            min-height: 100%;
            object-fit: cover;
            z-index: -1;
            filter: brightness(0.6);
        }

        /* Tetap gunakan background gambar sebagai fallback */
        body {
            background-image: url("set.jpg");
            background-attachment: fixed;
            background-size: cover;
            background-position: center;
            position: relative;
            color: white;
        }

        /* Warna tombol utama */
        .btn-primary {
            border-color: #ff5100;
            background-color: #ff5100 !important;
        }

        .btn-primary:hover {
            border-color: #e64900;
            background-color: #e64900 !important;
        }

        #btn-login:hover {
            background-color: #ff5100;
            color: white;
        }

        .navbar-brand:hover,
        .navbar-nav .nav-item a:hover {
            color: #ff5100 !important;
        }
        
        /* ============================= */
/* TEKS CAROUSEL AGAR TERBACA */
/* ============================= */
.carousel-caption h5,
.carousel-caption p {
    color: #ffffff;
    text-shadow:
        -1px -1px 0 #000,
         1px -1px 0 #000,
        -1px  1px 0 #000,
         1px  1px 0 #000,
         0  2px 6px rgba(0,0,0,0.7);
}

/* Judul lebih tegas */
.carousel-caption h5 {
    font-size: 2rem;
    font-weight: 700;
}

/* Paragraf lebih halus */
.carousel-caption p {
    font-size: 1.1rem;
    font-weight: 500;
}

/* ============================= */
/* TENTANG NAJWA RECORD - TEKS PUTIH */
/* ============================= */
.tentang-najwa {
    color: #ffffff;
}

.tentang-najwa p {
    color: #ffffff;
    opacity: 0.95;
}

.tentang-najwa h3 {
    color: #ffffff;
}


    </style>
</head>

<body>
    <!-- Video Background -->
    <video autoplay muted loop playsinline class="bg-video">
        <source src="vbg.mp4" type="video/mp4">
      
    </video>

    <?php
    include_once("database/koneksi.php");
    $result = $conn->query("SELECT * FROM tb_caraousel");
    $caraousel = $result->fetch_all(MYSQLI_ASSOC);
    ?>

    <?php include_once("partials/navbar_portfolio.php"); ?>

    <div id="carouselExampleCaptions"
     class="carousel slide carousel-fade"
     data-bs-ride="carousel"
     data-bs-interval="4000"
     data-bs-pause="hover">

    <div class="carousel-indicators">
        <?php foreach ($caraousel as $i => $row) : ?>
            <button type="button"
                data-bs-target="#carouselExampleCaptions"
                data-bs-slide-to="<?= $i ?>"
                class="<?= $i == 0 ? 'active' : '' ?>"
                aria-current="<?= $i == 0 ? 'true' : 'false' ?>"
                aria-label="Slide <?= $i + 1 ?>">
            </button>
        <?php endforeach; ?>
    </div>

    <div class="carousel-inner">
        <?php foreach ($caraousel as $i => $row) : ?>
            <div class="carousel-item <?= $i == 0 ? 'active' : '' ?>">
                <img src="<?= $row['gambar'] ?>"
                     class="d-block w-100"
                     height="400"
                     style="object-fit: cover;"
                     alt="<?= $row['judul'] ?>">
                <div class="carousel-caption d-none d-md-block">
                    <h5><?= $row['judul'] ?></h5>
                    <p><?= $row['keterangan'] ?></p>
                    <a href="paket.php">
                    <button type="button" class="btn btn-warning">Pesan Disini</button></a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <?php if (count($caraousel) > 1) : ?>
        <button class="carousel-control-prev" type="button"
            data-bs-target="#carouselExampleCaptions"
            data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button"
            data-bs-target="#carouselExampleCaptions"
            data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
        </button>
    <?php endif; ?>
</div>


    <?php
    $result = $conn->query("SELECT * FROM tb_portfolio_home");
    $data = $result->fetch_assoc();
    ?>
<?php include_once("layanan.php"); ?>
    <div class="container-fluid">
        <div class="row justify-content-center mb-3" style="background-color: rgba(0, 0, 0, 0.30);">
            <div class="col-md-8 col-xl-6">
                <div class="text-center mt-2 tentang-najwa">
                    <div class="py-4">
                        <h3 style="font-weight: 600;">TENTANG NAJWA RECORD</h3>
                        <p align="justify"><?= $data['profil'] ?? "Data belum diisi" ?></p>
                    </div>
                </div>
            </div>
        </div>

        <?php
        $result = $conn->query("SELECT * FROM tb_hasil_kerja");
        ?>
        <div class="row justify-content-center">
            <div class="col-12">
                <div class="text-center text-white">
                    <h3 style="font-weight: 600;">HASIL KERJA KAMI</h3>
                    <div class="py-4 row justify-content-center">
                        <?php while ($row = $result->fetch_assoc()) : ?>
                            <div class="col-md-6 col-xl-4 mb-3">
                                <iframe width="100%" height="350" src="https://www.youtube.com/embed/<?= $row['link_yt'] ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include_once("partials/footer_portfolio.php"); ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
</body>

</html>
