<?php
session_start();
include "../../database/koneksi.php";

// Ambil data klien (opsional)
$no = 1;
$queryKlien = "
    SELECT tb_klien.*, tb_user.username
    FROM tb_klien 
    INNER JOIN tb_user ON tb_user.id = tb_klien.id_user
";
$resKlien = $conn->query($queryKlien);
$dataKlien = $resKlien->fetch_assoc();
?>

<div class="content-wrapper">

<section class="content">
<div class="container-fluid">
<div class="row">
<div class="col-12">

<div class="card mt-3">

    <div class="card-header d-flex align-items-center">
        <h4 class="flex-grow-1 m-0 font-weight-bold">Data Pengajuan</h4>

        <?php if ($_SESSION['level'] == "KLIEN") : ?>
            <a href="?page=tambah_pengajuan&id=<?= $_GET['id'] ?>" class="btn btn-primary">Tambah</a>
        <?php endif; ?>
    </div>

    <style>
        .small-td { width: 1%; white-space: nowrap; }
        .btn-disabled {
            background-color: #ccc !important;
            border-color: #bbb !important;
            pointer-events: none;
            color: #666 !important;
        }
    </style>

    <div class="card-body">

        <table id="example2" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th class="text-center">No</th>
                    <th class="text-center small-td">Tanggal & Waktu Pemotretan</th>
                    <th class="text-center">Invoice</th>
                    <th class="text-center">Nama Lengkap</th>
                    <th class="text-center">Status Pengajuan</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>

            <tbody>

            <?php
            // Ambil data pengajuan
            $no = 1;

            $query = "
                SELECT 
                    tb_pengajuan.*,
                    tb_klien.nama_lengkap,
                    (SELECT nama FROM tb_konsep WHERE id=tb_pengajuan.konsep) AS konsep,
                    (SELECT nama FROM tb_paket WHERE id=tb_pengajuan.dokumentasi) AS dokumentasi
                FROM tb_pengajuan
                INNER JOIN tb_klien ON tb_pengajuan.id_klien = tb_klien.id
            ";

            if ($_SESSION['level'] == 'KLIEN') {
                $query .= " WHERE tb_klien.id = " . $_SESSION['id_klien'];
            } elseif ($_SESSION['level'] == 'ADMIN') {
                $query .= " WHERE tb_pengajuan.status='Pending'";
            }

            $result = $conn->query($query);

            // Bulan Indonesia
            $BULAN_DALAM_INDONESIA = [
                'Januari','Februari','Maret','April','Mei','Juni',
                'Juli','Agustus','September','Oktober','November','Desember'
            ];
            ?>

            <?php while ($row = $result->fetch_assoc()) : ?>

                <?php
                // Format tanggal
                $eng_date = explode('-', explode(' ', $row['tanggal_wedding'])[0]);
                $tanggal = $eng_date[2];
                $bulan   = $eng_date[1];
                $tahun   = $eng_date[0];

                // Logika aktif / nonaktif pembayaran
                $statusPengajuan = strtolower($row['status']);
                $bolehBayar = in_array($statusPengajuan, ['disetujui', 'diverifikasi']);

                $kelasPembayaran = $bolehBayar ? "btn-success" : "btn-disabled";
                $linkPembayaran  = $bolehBayar ? "?page=pembayaran&id=" . $row['id'] : "#";
                ?>

                <tr>
                    <td class="text-center"><?= $no++ ?></td>

                    <td class="text-center">
                        <?= $tanggal . " " . $BULAN_DALAM_INDONESIA[$bulan - 1] . " " . $tahun ?>
                        - Jam: <?= htmlspecialchars($row['jam']) ?>
                    </td>

                    <td class="text-center"><?= $row['invoice'] ?></td>

                    <td class="text-center"><?= $row['nama_lengkap'] ?></td>

                    <td class="text-center"><?= $row['status'] ?></td>

                    <td class="text-center small-td">

                        <!-- Tombol Pembayaran dinamis -->
                        <a href="<?= $linkPembayaran ?>" class="btn btn-sm <?= $kelasPembayaran ?>">
                            Pembayaran
                        </a>

                        <!-- Tombol Detail -->
                        <a href="?page=detail_pengajuan&id=<?= $row['id'] ?>" class="btn btn-sm btn-info">
                            Detail
                        </a>

                        <!-- Tombol Hapus -->
                        <form action="?page=hapus_pengajuan&id=<?= $row['id'] ?>" method="POST" class="d-inline">
                            <button type="submit" class="btn btn-sm btn-danger" 
                                    onclick="return confirm('Yakin ingin menghapus data ini?')">
                                Hapus
                            </button>
                        </form>
                    </td>
                </tr>

            <?php endwhile; ?>

            </tbody>
        </table>

    </div>
</div>

</div>
</div>
</div>
</section>

</div>

<script>
$(function() {
    $('#example2').DataTable({
        paging: true,
        lengthChange: true,
        searching: true,
        ordering: true,
        info: true,
        autoWidth: false,
        responsive: true,
    });
});
</script>
