<style>
/* === SELECT2 SOFT BLUE KHUSUS KONSEP & PAKET === */
.select2-container--bootstrap4 .select2-selection--single.select-soft-blue,
.select-soft-blue + .select2-container--bootstrap4 .select2-selection--single {
    height: 42px;
    border-radius: 8px;
    border: 1.5px solid #cfe2ff;
    background-color: #f5f9ff;
    display: flex;
    align-items: center;
    padding-left: 10px;
    transition: all 0.2s ease-in-out;
}

/* Text di dalam select */
.select2-container--bootstrap4 .select2-selection__rendered {
    color: #333;
    font-weight: 500;
}

/* Panah dropdown */
.select2-container--bootstrap4 .select2-selection__arrow b {
    border-color: #6ea8fe transparent transparent transparent;
}

/* Hover */
.select2-container--bootstrap4 .select2-selection--single:hover {
    background-color: #eef5ff;
    border-color: #9ec5fe;
}

/* Focus */
.select2-container--bootstrap4.select2-container--focus 
.select2-selection--single {
    background-color: #ffffff;
    border-color: #6ea8fe;
    box-shadow: 0 0 0 .15rem rgba(13,110,253,.15);
}

/* Dropdown list */
.select2-container--bootstrap4 .select2-dropdown {
    border-radius: 8px;
    border: 1px solid #cfe2ff;
}

/* Item hover */
.select2-container--bootstrap4 .select2-results__option--highlighted {
    background-color: #e7f1ff;
    color: #000;
}
</style>



<?php

if (isset($_GET['id'])) {
    $query = "SELECT 
                tb_klien.*,
                tb_user.id AS id_user,
                tb_user.username,
                tb_user.password 
            FROM 
                tb_klien 
            INNER JOIN 
                tb_user 
            ON 
                tb_user.id=tb_klien.id_user 
            WHERE 
                tb_klien.id=" . $_GET['id'];
    $result = $conn->query($query);
    $row = $result->fetch_assoc();
}


if (isset($_POST['submit'])) {
    $nik_l = $_POST['nik_l'];
    $invoice = mt_rand(10000, 99999);
    $nama_l = $_POST['nama_l'];
    $nomor_telepon_l = $_POST['nomor_telepon_l'];
    $tempat_wedding = $_POST['tempat_wedding'];
    $jam = $_POST['jam'];
    $tanggal_wedding = $_POST['tanggal_wedding'];
    $konsep = $_POST['konsep'];
    $dokumentasi = $_POST['dokumentasi'];
    $target_dir = "uploads/";

    $foto_l = $target_dir . basename($_FILES["foto_l"]["name"]) . "." . strtolower(pathinfo(basename($_FILES["foto_l"]["name"]), PATHINFO_EXTENSION));
    move_uploaded_file($_FILES["foto_l"]["tmp_name"], $foto_l);

    // Tambahan: Validasi apakah jam dan tanggal sudah ada di tb_pengajuan
    $cek_query = "SELECT COUNT(*) AS jumlah FROM tb_pengajuan WHERE tempat_wedding = '$tempat_wedding' AND jam = '$jam' AND status IN ('Pending', 'Approved')";
    $cek_result = $conn->query($cek_query);
    $cek_row = $cek_result->fetch_assoc();
    
    if ($cek_row['jumlah'] > 0) {
        echo "<script>alert('Pengajuan ditolak! Jam dan tempat pemotretan sudah dipesan. Mohon pilih Jam Berikutnya');</script>";
        // Opsional: Hapus file yang sudah diupload jika ditolak
        if (file_exists($foto_l)) {
            unlink($foto_l);
        }
    } else {
        // Jika belum ada, lanjutkan INSERT
        $query = "
            INSERT INTO tb_pengajuan 
            VALUES (
                NULL,
                '" . $_SESSION['id_klien'] . "',
                '$konsep',
                '$dokumentasi',
                '$invoice',
                '$nik_l',
                '$nama_l', 
                '$nomor_telepon_l',
                '$foto_l',
                '$tempat_wedding',
                '$jam',
                '$tanggal_wedding',
                NULL,
                NULL,
                'Pending',
                NULL
            )";
        if ($conn->query($query)) {
            echo "<script>alert('Pengajuan berhasil dilakukan!');</script>";
            echo "<script>window.location.href = '?page=pengajuan';</script>";
        } else echo $query . ": " . $conn->error;
    }
}

?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Pengajuan Pemesanan</h1>
                </div>
            </div>
        </div></section>

    <section class="content">
        <div class="container-fluid">
            <form action="" method="POST" enctype="multipart/form-data">
                
                <?php 
                // Asumsi $conn sudah terdefinisi dan berfungsi
                $gambar = []; 
                $result_konsep = $conn->query("SELECT * FROM tb_konsep"); 
                while ($row_konsep = $result_konsep->fetch_assoc()) {
                    $konsep_data = $conn->query("SELECT * FROM tb_gambar_konsep WHERE id_konsep=" . $row_konsep['id']);
                    $gambar['konsep'][$row_konsep['id']] = $konsep_data->fetch_all(MYSQLI_ASSOC);
                    $konsep_list[] = $row_konsep; // Menyimpan data konsep
                }
                
                $result_paket = $conn->query("SELECT * FROM tb_paket WHERE id"); 
                while ($row_paket = $result_paket->fetch_assoc()) {
                    $paket_data = $conn->query("SELECT * FROM tb_gambar_paket WHERE id_paket=" . $row_paket['id']);
                    $gambar['paket'][$row_paket['id']] = $paket_data->fetch_all(MYSQLI_ASSOC);
                    $paket_list[] = $row_paket; // Menyimpan data paket
                }
                ?>

                <div id="a" class="row justify-content-center">
                    <div class="col-lg-10">
                        <div class="card card-primary">
                            <div class="card-header">
                                <h3 class="card-title">1. Identitas Pemesanan & Jadwal</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    
                                    <div class="col-md-6 border-right">
                                        <h5 class="text-center text-primary mb-3">Identitas Pelanggan</h5>
                                        
                                        <div class="form-group">
                                            <label for="nik_l">NIK KTP/SIM</label>
                                            <input type="text" class="form-control" id="nik_l" name="nik_l" placeholder="Masukkan NIK KTP" value="<?= $row['nik'] ?? ''; ?>" readonly>
                                        </div>
                                        <div class="form-group">
                                            <label for="nama_l">Nama Lengkap</label>
                                            <input type="text" class="form-control" id="nama_l" name="nama_l" placeholder="Masukkan Nama Lengkap" value="<?= $row['nama_lengkap'] ?? ''; ?>" readonly>
                                        </div>
                                        <div class="form-group">
                                            <label for="nomor_telepon_l">Nomor Telepon</label>
                                            <input type="text" class="form-control" id="nomor_telepon_l" name="nomor_telepon_l" placeholder="Masukkan Nomor Telepon" value="<?= $row['nomor_telepon'] ?? ''; ?>" readonly>
                                        </div>
                                        <div class="form-group">
                                            <label for="foto_l">Foto Pelanggan</label>
                                            <div class="input-group">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="foto_l" name="foto_l">
                                                    <label id="label_gambar_l" class="custom-file-label" for="foto_l">Pilih Gambar</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <h5 class="text-center text-primary mb-3">Jadwal Pemotretan</h5>

                                        <div class="form-group">
                                            <label for="tanggal_wedding">Tanggal Pemotretan</label>
                                            <input type="date" class="form-control" id="tanggal_wedding" name="tanggal_wedding">
                                        </div>
                                        <div class="form-group">
                                            <label for="tempat_wedding">Tempat Pemotretan</label>
                                            <select class="form-control" name="tempat_wedding">
                                                <option value=''>[Pilih]</option>
                                                <option value='Indoor - Studio Najwa Record'>Indoor - Studio Najwa Record</option>
                                                <option value='Outdoor - '>Outdoor - </option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="jam">Jam Pemotretan</label>
                                            <select class="form-control" name="jam" id="jam">
    <option value=''>[Pilih]</option>
</select>

                                        </div>
                                        
                                        <div class="form-group text-center">
                                            <label>Preview Gambar</label>
                                            <div class="d-flex justify-content-center mt-2">
                                                
                                                <img id="preview-foto-l" src="assets/img/pp.png" class="img-thumbnail img-fluid" style="width: 120px; height: 170px; object-fit: cover;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer d-flex justify-content-end">
                                <button type="reset" class="btn btn-secondary mr-2">Reset</button>
                                <button id="next-btn" type="button" class="btn btn-primary">Next</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="b" class="row d-none justify-content-center">
                    <div class="col-lg-10">
                        <div class="card card-info">
                            <div class="card-header">
                                <h3 class="card-title">2. Pilih Konsep & Paket</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    
                                    <div class="col-md-4 border-right">
                                        <h5 class="text-info text-center mb-3">Pilihan Pemotretan</h5>
                                        
                                        <div class="form-group">
    <label>Konsep Pemotretan</label>
    <select name="konsep"
            class="form-control select2bs4 select-soft-blue"
            onchange="berubah(this, 'konsep', 'konsep')">
        <option value="">[Pilih]</option>
        <?php foreach ($konsep_list as $row_konsep) : ?>
            <option 
                data-id="<?= $row_konsep['id'] ?>" 
                data-nama="<?= $row_konsep['nama'] ?>" 
                data-harga="0"
                data-detail="<?= htmlspecialchars($row_konsep['detail']); ?>" 
                value="<?= $row_konsep['id'] ?>">
                <?= $row_konsep['nama'] ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

                                        
                                        <div class="form-group">
    <label>Pilih Paket</label>
    <select name="dokumentasi"
            class="form-control select2bs4 select-soft-blue"
            onchange="berubah(this, 'paket', 'dokumentasi')">
        <option value="">[Pilih]</option>
        <?php foreach ($paket_list as $row_paket) : ?>
            <option 
                data-harga="<?= $row_paket['harga']; ?>" 
                data-id="<?= $row_paket['id'] ?>" 
                data-nama="<?= $row_paket['nama'] ?>" 
                data-detail="<?= htmlspecialchars($row_paket['detail']); ?>" 
                value="<?= $row_paket['id'] ?>">
                <?= $row_paket['nama'] ?> — Rp <?= number_format($row_paket['harga'], 0, ',', '.') ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

                                        
                                        <h1 id="total_biaya" class="mt-4 text-danger">Total Biaya: Rp. 0</h1>
                                        <input type="hidden" name="harga_total" id="harga_total" value="0">
                                    </div>
                                    
                                    <div class="col-md-8">
                                        <div class="card card-default" style="height: 100%;">
                                            <div class="card-header">
                                                <h3 class="card-title" id="nama_master">Detail Pilihan</h3>
                                            </div>
                                            <div class="card-body">
                                                <p id="detail_master" class="text-muted">Pilih Konsep atau Paket untuk melihat detail dan gambar.</p>
                                                
                                                <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                                                    <div class="carousel-inner" style="max-height: 350px;">
                                                        <div class="carousel-item active">
                                                            <div class="d-flex justify-content-center align-items-center" style="height: 350px; background-color: #f8f9fa;">
                                                                <p class="text-secondary">Preview Gambar Konsep/Paket</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <button class="carousel-control-prev" type="button" data-target="#carouselExampleControls" data-slide="prev">
                                                        <span class="carousel-control-prev-icon bg-dark" aria-hidden="true"></span>
                                                        <span class="sr-only">Previous</span>
                                                    </button>
                                                    <button class="carousel-control-next" type="button" data-target="#carouselExampleControls" data-slide="next">
                                                        <span class="carousel-control-next-icon bg-dark" aria-hidden="true"></span>
                                                        <span class="sr-only">Next</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer d-flex justify-content-end">
                                <button id="back-btn" type="button" class="btn btn-secondary mr-2">Back</button>
                                <button type="submit" name="submit" class="btn btn-success">Submit Pemesanan</button>
                            </div>
                        </div>
                    </div>
                </div>
                </form>
        </div>
    </section>
</div>

<script>
    // 1. Data PHP di-encode ke JavaScript
    const gambarData = <?= json_encode($gambar); ?>;
    let total_biaya = {}; // Objek untuk melacak harga Konsep dan Paket

    // 2. Inisialisasi Select2
    $('.select2bs4').select2({
        theme: 'bootstrap4',
        width: '100%'
    });

    // 3. Logic Multi-Step
    document.querySelector('#next-btn').addEventListener('click', function() {
        // Cek validasi minimal sebelum lanjut (Opsional: tambahkan validasi form wajib di sini)
        document.querySelector('#a').classList.add('d-none');
        document.querySelector('#b').classList.remove('d-none');
        // Pastikan carousel diinisialisasi ulang saat tampilan b muncul
        $('#carouselExampleControls').carousel(0);
    });

    document.querySelector('#back-btn').addEventListener('click', function() {
        document.querySelector('#b').classList.add('d-none');
        document.querySelector('#a').classList.remove('d-none');
    });

    // 4. Logic Preview Foto Pelanggan
    $("#foto_l").on('change', function() {
        const image = $(this);
        const oFReader = new FileReader();
        if (image[0].files.length > 0) {
            oFReader.readAsDataURL(image[0].files[0]);
            oFReader.onload = function(oFREvent) {
                $("#preview-foto-l").attr('src', oFREvent.target.result);
                $("#label_gambar_l").text(image[0].files[0].name);
            }
        } else {
            // Jika file dibatalkan
            $("#preview-foto-l").attr('src', 'assets/img/pp.png');
            $("#label_gambar_l").text('Pilih Gambar');
        }
    });

    // 5. Logic Update Konsep/Paket (Fungsi `berubah`)
    function berubah(element, jenis, harga_key) {
        const selectedOption = element.options[element.options.selectedIndex];
        const id = selectedOption.getAttribute('data-id');
        const nama = selectedOption.getAttribute('data-nama');
        const detail = selectedOption.getAttribute('data-detail');
        const harga = selectedOption.getAttribute('data-harga');

        // Update Detail
        document.querySelector("#nama_master").innerHTML = nama || "Detail Pilihan";
        document.querySelector("#detail_master").innerHTML = detail || "Pilih Konsep atau Paket untuk melihat detail dan gambar.";

        // Update Harga
        if (harga_key && harga) {
            total_biaya[harga_key] = parseInt(harga) || 0;
        } else if (harga_key) {
             // Jika memilih '[Pilih]' atau konsep tanpa harga
             total_biaya[harga_key] = 0;
        }

        let real_total = 0;
        for (const key in total_biaya) {
            real_total += total_biaya[key];
        }
        document.querySelector("#total_biaya").innerHTML = "Total Biaya: " + formatRupiah(real_total.toString(), "Rp. ");
        document.querySelector("#harga_total").value = real_total; // Update hidden input

        // Update Carousel
        const carouselInner = document.querySelector(".carousel-inner");
        carouselInner.innerHTML = "";
        
        const images = gambarData[jenis][id];
        if (images && images.length > 0) {
            images.forEach((img, index) => {
                const activeClass = index === 0 ? ' active' : '';
                carouselInner.insertAdjacentHTML('beforeend', ` 
                    <div class="carousel-item${activeClass}">
                        
                        <img class="d-block w-100" style="object-fit: cover; max-height: 350px;" src="${img.gambar}" alt="Gambar ${jenis}">
                    </div>`);
            });
             // Restart carousel untuk menampilkan slide pertama
            $('#carouselExampleControls').carousel(0);
        } else {
            // Placeholder jika tidak ada gambar
            carouselInner.insertAdjacentHTML('beforeend', `
                <div class="carousel-item active">
                    <div class="d-flex justify-content-center align-items-center" style="height: 350px; background-color: #f8f9fa;">
                        <p class="text-secondary">Tidak ada gambar preview untuk pilihan ini.</p>
                    </div>
                </div>`);
        }
    }

    // 6. Fungsi Format Rupiah
    function formatRupiah(angka, prefix) {
        var number_string = angka.replace(/[^,\d]/g, '').toString(),
            split = number_string.split(','),
            sisa = split[0].length % 3,
            rupiah = split[0].substr(0, sisa),
            ribuan = split[0].substr(sisa).match(/\d{3}/gi);

        if (ribuan) {
            separator = sisa ? '.' : '';
            rupiah += separator + ribuan.join('.');
        }

        rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
        return prefix == undefined ? rupiah : (rupiah ? 'Rp. ' + rupiah : '');
    }
    
    //7. Fungsi Tersedia
$(document).ready(function() {

    function loadJam() {
        let tanggal = $("#tanggal_wedding").val();
        let tempat = $("select[name='tempat_wedding']").val();

        if (tanggal === "" || tempat === "") {
            $("select[name='jam']").html("<option value=''>[Pilih]</option>");
            return;
        }

        $.ajax({
            url: "pengajuan/cek_jam.php",
            type: "POST",
            data: {
                tanggal: tanggal,
                tempat: tempat
            },
            success: function(response) {
                $("select[name='jam']").html(response);
            }
        });
    }

    $("#tanggal_wedding, select[name='tempat_wedding']").on("change", function() {
        loadJam();
    });

});
</script>




