<?php
// =========================
// AMBIL DATA PENGAJUAN
// =========================
if (isset($_GET['id'])) {
    $query = "
        SELECT 
            tb_pengajuan.*,
            tb_klien.nik,
            tb_klien.nama_lengkap,
            tb_klien.email,
            (SELECT nama FROM tb_konsep WHERE id = tb_pengajuan.konsep) AS konsep,
            (SELECT nama FROM tb_paket WHERE id = tb_pengajuan.dokumentasi) AS dokumentasi,
            (SELECT harga FROM tb_paket WHERE id = tb_pengajuan.dokumentasi) AS harga_dokumentasi
        FROM tb_pengajuan
        INNER JOIN tb_klien ON tb_pengajuan.id_klien = tb_klien.id
        WHERE tb_pengajuan.id = " . $_GET['id'];

    $result = $conn->query($query);
    $data   = $result->fetch_assoc();
}

// =========================
// SETUJUI PENGAJUAN
// =========================
if (isset($_POST['disetujui'])) {
    $conn->query("UPDATE tb_pengajuan SET status='Disetujui' WHERE id=" . $data['id']);
    new MailSender($data['email'], "PENGAJUAN", "DISETUJUI");
    echo "<script>window.location.href='?page=pengajuan';</script>";
}
?>

<style>
/* ========================= */
/*  STYLE CETAK (FIXED)      */
/* ========================= */
@media print {

    body {
        margin: 0;
        padding: 0;
        font-size: 12pt;
        color: #000;
        background: #fff;
    }

    /* sembunyikan elemen yang tidak perlu */
    .content-header,
    .card-header,
    .card-footer,
    .btn,
    nav,
    aside {
        display: none !important;
    }

    /* area yang dicetak */
    #section-to-print {
        display: block;
        width: 100%;
    }

    /* paksa grid bootstrap tetap rapi */
    .row {
        display: flex !important;
        flex-wrap: wrap !important;
    }

    .col-md-6 {
        width: 50% !important;
    }

    .col-md-12 {
        width: 100% !important;
    }

    /* hindari konten terpotong */
    img {
        max-width: 100%;
        page-break-inside: avoid;
    }

    .table-detail,
    .price-row {
        page-break-inside: avoid;
    }

    /* setting kertas */
    @page {
        size: landscape;
        margin: 15mm;
    }
}

/* ========================= */
/*  RAPIKAN RINCIAN HARGA    */
/* ========================= */
.price-row {
    display: flex;
    justify-content: space-between;
    padding: 6px 0;
}

.price-label {
    flex: 1;
}

.price-amount {
    min-width: 180px;
    text-align: right;
    font-family: "Courier New", monospace;
    font-weight: bold;
}
</style>

<!-- ========================= -->
<!--  CONTENT WRAPPER          -->
<!-- ========================= -->
<div class="content-wrapper">

    <section class="content-header">
        <div class="container-fluid">
            <h1 class="mb-2">Detail Pengajuan</h1>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            <div class="row">

                <div class="col-md-12" id="a">
                    <div class="card card-primary">

                        <div class="card-header">
                            <h3 class="card-title">Data Pengajuan</h3>
                        </div>

                        <div class="card-body" id="section-to-print">

                            <div class="row">

                                <!-- ========================= -->
                                <!--  KOLOM KIRI               -->
                                <!-- ========================= -->
                                <div class="col-md-6">

                                    <h5 class="font-weight-bold mb-3">Data Pengajuan</h5>

                                    <div class="table-detail">
                                        <div class="row">
                                            <div class="col-4">Invoice</div>
                                            <div class="col">: <?= $data['invoice'] ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">ID Pelanggan</div>
                                            <div class="col">: <?= $data['id_klien'] ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">Nama Lengkap</div>
                                            <div class="col">: <?= $data['nama_l'] ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">Telepon</div>
                                            <div class="col">: <?= $data['nomor_telepon_l'] ?></div>
                                        </div>

                                        <?php
                                            $eng_date = explode('-', explode(' ', $data['tanggal_wedding'])[0]);
                                            $tgl = $eng_date[2];
                                            $bln = $eng_date[1];
                                            $thn = $eng_date[0];
                                        ?>
                                        <div class="row">
                                            <div class="col-4">Tanggal</div>
                                            <div class="col">: <?= $tgl . " " . $BULAN_DALAM_INDONESIA[$bln - 1] . " " . $thn ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">Jam</div>
                                            <div class="col">: <?= $data['jam'] ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">Tempat</div>
                                            <div class="col">: <?= $data['tempat_wedding'] ?></div>
                                        </div>
                                        <div class="row">
                                            <div class="col-4">Konsep</div>
                                            <div class="col">: <?= $data['konsep'] ?></div>
                                        </div>
                                    </div>

                                </div>

                                <!-- ========================= -->
                                <!--  KOLOM KANAN              -->
                                <!-- ========================= -->
                                <!-- KOLOM KANAN: Rincian Paket (GANTI BAGIAN INI) -->
<div class="col-md-6">

    <h5 class="font-weight-bold mb-3">Rincian Paket</h5>

    <div class="table-detail">

        <div class="price-row">
            <div class="price-label">Paket Foto</div>
            <div class="price-amount"><?= htmlspecialchars($data['dokumentasi']) ?></div>
        </div>

        <hr>

        <div class="price-row">
            <div class="price-label">Harga Paket</div>
            <div class="price-amount">Rp <?= number_format($data['harga_dokumentasi'], 0, ",", ".") ?></div>
        </div>

        <div class="price-row">
            <div class="price-label">Biaya Tambahan</div>
            <div class="price-amount">Rp 0</div>
        </div>

        <div class="price-row" style="border-top:1px dashed rgba(0,0,0,0.08); margin-top:8px; padding-top:10px;">
            <div class="price-label"><strong>Total</strong></div>
            <div class="price-amount"><strong>Rp <?= number_format($data['harga_dokumentasi'], 0, ",", ".") ?></strong></div>
        </div>

        <div class="row mt-3">
            <div class="col">
                <img src="<?= $data['foto_l'] ?>" class="img-thumbnail" style="width:150px; height:200px; object-fit:cover;">
            </div>
        </div>

    </div>

</div>
<!-- AKHIR KOLOM KANAN -->


                        <!-- ========================= -->
                        <!-- BUTTON FOOTER            -->
                        <!-- ========================= -->
                        <div class="card-footer text-right">
                            <a href="?page=pengajuan" class="btn btn-secondary mr-3">Kembali</a>
                            <button id="cetak" class="btn btn-info mr-3">Cetak</button>

                            <?php if ($data['status'] === 'Pending' && $_SESSION['level'] == 'ADMIN'): ?>
                                <a href="?page=tolak_pengajuan&id=<?= $data['id'] ?>&email=<?= $data['email'] ?>" class="btn btn-danger mr-3">Tolak</a>
                                <a href="?page=setujui_pengajuan&id=<?= $data['id'] ?>&email=<?= $data['email'] ?>" class="btn btn-success">Setujui</a>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

</div>

<!-- ========================= -->
<!--  SCRIPT CETAK            -->
<!-- ========================= -->
<script>
document.querySelector("#cetak").addEventListener('click', function () {
    // langsung print — layout tetap terjaga karena .price-amount punya lebar tetap
    window.print();
});


window.onafterprint = () => {
    document.querySelectorAll('.lebarin').forEach(el => {
        el.classList.add('col-4');
        el.classList.remove('col-10');
    });
};
</script>
