  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
      <!-- Content Header (Page header) -->

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">

                      <div class="card mt-3">
                          <div class="card-header d-flex align-items-center">
                              <h4 class="flex-grow-1 m-0 font-weight-bold">Data Pembayaran</h4>
                          </div>
                          <!-- /.card-header -->
                          <style>
                              .small-td {
                                  width: 1%;
                                  white-space: nowrap;
                              }
                          </style>
                          <div class="card-body">
                              <table id="example2" class="table table-bordered table-striped">
                                  <thead>
                                      <tr>
                                          <th class="text-center">No</th>
                                          <th class="text-center small-td">Nama Klien</th>
                                          <th class="text-center">Total Anggaran</th>
                                          <th class="text-center">Status</th>
                                          <th class="text-center">Pembayaran</th>
                                      </tr>
                                  </thead>
                                  <tbody>
                                      <?php
                                        $no = 1;

                                        // Query SQL untuk mendapatkan data
                                        $query = "
    SELECT 
        tb_pembayaran.status,
        tb_anggaran.*,
        tb_klien.nama_lengkap,
        tb_pengajuan.id AS id_pengajuan,
        (
          (SELECT harga FROM tb_paket WHERE id = tb_pengajuan.dokumentasi LIMIT 1)
        ) AS harga_dokumentasi
    FROM 
        tb_anggaran 
    INNER JOIN 
        tb_pengajuan 
    ON 
        tb_pengajuan.id = tb_anggaran.id_pengajuan 
    INNER JOIN 
        tb_klien 
    ON 
        tb_pengajuan.id_klien = tb_klien.id 
    LEFT JOIN 
        tb_pembayaran 
    ON 
        tb_anggaran.id = tb_pembayaran.id_anggaran";

                                        // Filter untuk level ADMIN
                                        if ($_SESSION['level'] == 'ADMIN') {
                                            $query .= " WHERE tb_pembayaran.status = 'Menunggu Verifikasi'";
                                        }

                                        // Filter untuk level KLIEN
                                        if ($_SESSION['level'] == 'KLIEN') {
                                            $query .= " WHERE tb_klien.id = " . (int)$_SESSION['id_klien'];
                                        }

                                        // Eksekusi query
                                        $result = $conn->query($query);

                                        // Periksa jika query gagal
                                        if (!$result) {
                                            die("Error pada query: " . $conn->error);
                                        }
                                        ?>

                                      <!-- Loop untuk menampilkan data -->
                                      <?php while ($row = $result->fetch_assoc()) : ?>
                                          <tr>
                                              <td class="text-center"><?= $no++ ?></td>
                                              <td class="text-center"><?= htmlspecialchars($row['nama_lengkap']) ?></td>
                                              <td class="text-center"><?= number_format($row['harga_dokumentasi'] + $row['anggaran_tambahan'], 0, ',', '.') ?></td>
                                              <td class="text-center"><?= is_null($row['status']) ? "Belum Dibayar" : htmlspecialchars($row['status']) ?></td>
                                              <td class="text-center">
                                                  <a href="?page=detail_pembayaran&id=<?= (int)$row['id_pengajuan'] ?>" class="btn btn-primary">Detail Pembayaran</a>
                                              </td>
                                          </tr>
                                      <?php endwhile; ?>
                                  </tbody>

                              </table>
                          </div>
                          <!-- /.card-body -->
                      </div>
                      <!-- /.card -->
                  </div>
                  <!-- /.col -->
              </div>
              <!-- /.row -->
          </div>
          <!-- /.container-fluid -->
      </section>
      <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <script>
      $(function() {
          $('#example2').DataTable({
              "paging": true,
              "lengthChange": true,
              "searching": true,
              "ordering": true,
              "info": true,
              "autoWidth": false,
              "responsive": true,
          });
      });
  </script>