<?php

if (isset($_GET['id'])) {
    $query = "
    SELECT 
    tb_pembayaran.status AS status_pembayaran,
    tb_pembayaran.id AS id_pembayaran,
    tb_pembayaran.file_bukti_pembayaran,
    tb_bank.nama AS nama_bank,
    tb_bank.atas_nama,
    tb_bank.no_rek,
    tb_pengajuan.*,
    tb_klien.nik,
    tb_klien.nama_lengkap,
    tb_klien.email,
    tb_anggaran.id AS id_anggaran,
    tb_anggaran.anggaran_tambahan,
    tb_anggaran.detail_anggaran,
    (SELECT nama FROM tb_konsep WHERE id=tb_pengajuan.konsep) AS konsep,
    (SELECT nama FROM tb_paket WHERE id=tb_pengajuan.dokumentasi) AS dokumentasi,
    (SELECT harga FROM tb_paket WHERE id=tb_pengajuan.dokumentasi) AS harga_dokumentasi
    FROM 
        tb_pengajuan 
    INNER JOIN 
        tb_klien 
    ON 
        tb_pengajuan.id_klien=tb_klien.id 
    INNER JOIN 
        tb_anggaran 
    ON 
        tb_pengajuan.id=tb_anggaran.id_pengajuan 
    LEFT JOIN 
        tb_pembayaran 
    ON 
        tb_anggaran.id=tb_pembayaran.id_anggaran 
    LEFT JOIN 
        tb_bank 
    ON 
        tb_bank.id=tb_pembayaran.id_bank 
    WHERE 
        tb_pengajuan.id=" . $_GET['id'];
    $result = $conn->query($query);
    $data = $result->fetch_assoc();
}

if (isset($_POST['verifikasi'])) {
    if ($_POST['verifikasi'] == 'tolak') {
        $keterangan = $_POST['keterangan'];
        $query = "UPDATE tb_pembayaran SET keterangan='$keterangan', status='Ditolak', tanggal_verifikasi='" . Date("Y-m-d H:i:s") . "' WHERE id=" . $data['id_pembayaran'];
        $conn->query($query);
        // new MailSender($data['email'], "PENGAJUAN", "DISETUJUI");
        echo "<script>alert('berhasil verifikasi');window.location.href = '?page=pembayaran';</script>";
    } else if ($_POST['verifikasi'] == 'verifikasi') {
        $keterangan = $_POST['keterangan'];
        $query = "UPDATE tb_pembayaran SET keterangan='$keterangan', status='Terverifikasi', tanggal_verifikasi='" . Date("Y-m-d H:i:s") . "' WHERE id=" . $data['id_pembayaran'];
        $conn->query($query);
        // new MailSender($data['email'], "PENGAJUAN", "DISETUJUI");
        echo "<script>alert('berhasil verifikasi');window.location.href = '?page=pembayaran';</script>";
    }
}

?>



<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2 justify-content-center">
                <div class="col-sm-12">
                    <h1 class="text-center">Detail Pembayaran</h1>
                </div>
            </div>
        </div></section>

    <section class="content">
        <div class="container-fluid">
            <div class="row justify-content-center">

<div class="col-md-6">
    <div class="card card-primary shadow-sm">
        <div class="card-header">
            <h3 class="card-title">Rincian Pengajuan & Biaya</h3>
        </div>

        <div class="card-body">

            <!-- Invoice -->
            <h5 class="mb-3" style="font-weight: bold;">Invoice</h5>
            <dl class="row mb-4">
                <dt class="col-sm-4">Nomor Invoice</dt>
                <dd class="col-sm-8">: <b><?= $data['invoice'] ?></b></dd>
            </dl>

            <!-- Rincian Paket -->
            <h5 class="mb-3" style="font-weight: bold;">Rincian Paket</h5>
            <dl class="row mb-4">
                <dt class="col-sm-4">Nama Klien</dt>
                <dd class="col-sm-8">: <b><?= $data['nama_lengkap'] ?></b></dd>

                <dt class="col-sm-4">Konsep</dt>
                <dd class="col-sm-8">: <?= $data['konsep'] ?></dd>

                <dt class="col-sm-4">Paket</dt>
                <dd class="col-sm-8">: <?= $data['dokumentasi'] ?></dd>
            </dl>

            <!-- Rincian Biaya -->
            <h5 class="mb-3" style="font-weight: bold;">Rincian Biaya</h5>
            <table class="table table-sm table-borderless mb-0">
                <tbody>
                    <tr>
                        <td>Harga Paket</td>
                        <td class="text-right">Rp. <?= number_format($data['harga_dokumentasi'], 0, ",", "."); ?></td>
                    </tr>
                    <tr>
                        <td>Biaya Tambahan</td>
                        <td class="text-right">Rp. <?= number_format($data['anggaran_tambahan'], 0, ",", "."); ?></td>
                    </tr>
                    <tr class="border-top border-dark">
                        <td style="font-weight: bold;">TOTAL PEMBAYARAN</td>
                        <td class="text-right" style="font-weight: bold;">
                            Rp. <?= number_format($data['harga_dokumentasi'] + $data['anggaran_tambahan'], 0, ",", "."); ?>
                        </td>
                    </tr>
                </tbody>
            </table>

        </div>

        <div class="card-footer d-flex justify-content-end">
            <a href="?page=pembayaran" class="btn btn-secondary mr-3">Kembali</a>

            <?php if ($_SESSION['level'] === "KLIEN") : ?>
                <?php if ($data['status_pembayaran'] == "Terverifikasi") : ?>
                    <button class="btn btn-success" disabled>Berhasil Melakukan Pembayaran</button>
                <?php else : ?>
                    <a href="?page=tambah_pembayaran&id=<?= $data['id_anggaran'] ?>&total=<?= ($data['harga_dokumentasi'] + $data['anggaran_tambahan']) ?>" class="btn btn-primary">
                        Lakukan Pembayaran
                    </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php if ($_SESSION['level'] === "ADMIN") : ?>
<div class="col-md-6">
    <div class="card card-info shadow-sm">
        <div class="card-header">
            <h3 class="card-title">Informasi & Bukti Pembayaran</h3>
        </div>

        <form action="" method="POST">
            <div class="card-body">

                <h5 class="mb-3" style="font-weight: bold;">Detail Transfer</h5>
                <dl class="row mb-4">
                    <dt class="col-sm-4">Bank</dt>
                    <dd class="col-sm-8">: <?= $data['nama_bank'] ?></dd>

                    <dt class="col-sm-4">Atas Nama</dt>
                    <dd class="col-sm-8">: <?= $data['atas_nama'] ?></dd>

                    <dt class="col-sm-4">No Rekening</dt>
                    <dd class="col-sm-8">: <?= $data['no_rek'] ?></dd>
                </dl>

                <h5 class="mb-3" style="font-weight: bold;">Bukti Pembayaran</h5>
                <div class="text-center mb-3">
                    <a href="<?= $data['file_bukti_pembayaran'] ?>" target="_blank">
                        <img src="<?= $data['file_bukti_pembayaran'] ?>" 
                             class="img-fluid img-thumbnail"
                             style="max-height: 250px; object-fit: contain;">
                    </a>
                    <small class="text-muted d-block mt-2">Klik gambar untuk memperbesar</small>
                </div>

                <h5 class="mb-3" style="font-weight: bold;">Verifikasi Admin</h5>

                <div class="form-group">
                    <label>Keterangan (Opsional)</label>
                    <input type="text" name="keterangan" class="form-control" placeholder="Tulis catatan verifikasi atau alasan penolakan">
                </div>

            </div>

            <div class="card-footer d-flex justify-content-start">
                <button type="submit" name="verifikasi" value="tolak" class="btn btn-danger mr-3"
                    onclick="return confirm('Tolak pembayaran?');">
                    Tolak Pembayaran
                </button>

                <button type="submit" name="verifikasi" value="verifikasi" class="btn btn-success"
                    onclick="return confirm('Verifikasi pembayaran?');">
                    Verifikasi Pembayaran
                </button>
            </div>
        </form>
    </div>
</div>
<?php endif; ?>

                </div>
            </div>
        </section>
    </div>