<?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Navbar</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        .navbar {
            transition: all 0.3s ease;
        }

        .nav-link {
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .nav-link.active {
            color: #ff5100 !important;
            font-weight: 600;
        }

        .nav-link:hover {
            color: #ff5100 !important;
        }

        .btn-login {
            border-color: #ff5100;
            color: #fff;
        }

        .btn-login:hover {
            background-color: #ff5100;
            border-color: #ff5100;
        }

        .btn-register {
            background-color: #ff5100;
            border: none;
        }

        .btn-register:hover {
            background-color: #e64900;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm sticky-top">
    <div class="container">

        <a class="navbar-brand" href="portfolio.php">
            <img src="assets/img/logo1.png" width="150" alt="Logo">
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0 gap-lg-2">

                <li class="nav-item">
                    <a class="nav-link <?= $currentPage == 'portfolio.php' ? 'active' : '' ?>"
                       href="portfolio.php">
                        <i class="bi bi-house"></i> Home
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?= $currentPage == 'paket.php' ? 'active' : '' ?>"
                       href="paket.php">
                        <i class="bi bi-box-seam"></i> Paket Layanan
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?= $currentPage == 'konsep.php' ? 'active' : '' ?>"
                       href="konsep.php">
                        <i class="bi bi-easel"></i> Konsep Pemotretan
                    </a>
                </li>

                <li class="nav-item">
                    <a class="nav-link <?= $currentPage == 'crew.php' ? 'active' : '' ?>"
                       href="crew.php">
                        <i class="bi bi-person-badge"></i> Crew Najwa
                    </a>
                </li>

            </ul>

            <div class="d-flex gap-2">
                <a href="index.php?page=login" class="btn btn-outline-light btn-sm btn-login">
                    <i class="bi bi-box-arrow-in-right"></i> Login
                </a>
                <a href="index.php?page=register" class="btn btn-sm btn-register text-white">
                    Daftar Pelanggan <i class="bi bi-person-plus"></i>
                </a>
            </div>
        </div>
    </div>
</nav>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
