<?php
$bank = $conn->query("SELECT * FROM tb_bank ORDER BY id ASC");
?>

<div class="content-wrapper">

    <section class="content-header">
        <div class="container-fluid">
            <h3 class="text-center mb-4" style="font-weight:bold;">Cara Pembayaran</h3>
        </div>
    </section>

    <section class="content">
        <div class="container">

            <div class="card shadow-lg border-0">
                <div class="card-header text-white" style="background:#ff5100;">
                    <h5 class="m-0">Panduan Pembayaran</h5>
                </div>

                <div class="card-body">

                    <p class="lead">
                        Terima kasih telah menggunakan layanan <b>Najwa Record</b>.  
                        Ikuti langkah berikut untuk melakukan pembayaran:
                    </p>

                    <ol class="list-group list-group-numbered mb-4">
                        <li class="list-group-item">Pilih metode pembayaran di bawah.</li>
                        <li class="list-group-item">Lakukan pembayaran sesuai total tagihan.</li>
                        <li class="list-group-item">Upload bukti pembayaran pada menu pembayaran.</li>
                        <li class="list-group-item">Tunggu verifikasi admin (1×24 jam).</li>
                    </ol>

                    <h5 class="mt-4 mb-3" style="font-weight:bold;">Metode Pembayaran</h5>

                    <div class="row">

                        <?php while($row = $bank->fetch_assoc()): ?>

                            <?php
                            $nama = strtoupper($row['nama']);
                            $icon = "fas fa-university text-primary";

                            if (strpos($nama, "WALLET") !== false) $icon = "fas fa-wallet text-warning";
                            if (strpos($nama, "TUNAI") !== false) $icon = "fas fa-money-bill-wave text-success";
                            ?>

                            <div class="col-md-4 col-12 mb-3">
                                <div class="border rounded p-3 text-center shadow-sm">

                                    <i class="<?= $icon ?> fa-2x mb-2"></i>
                                    <h6 class="mt-2"><?= $row['nama'] ?></h6>
                                    <hr>

                                    <?php if ($row['no_rek'] != "0"): ?>
                                        
                                        <p class="mb-1">Nomor: 
                                            <b id="copyText<?= $row['id'] ?>"><?= $row['no_rek'] ?></b>
                                        </p>

                                        <p class="mb-1">a.n <b><?= $row['atas_nama'] ?></b></p>

                                        <button 
                                            class="btn btn-sm btn-primary mt-2"
                                            onclick="copyToClipboard('copyText<?= $row['id'] ?>')"
                                        >
                                            <i class="fas fa-copy"></i> Copy
                                        </button>

                                    <?php else: ?>

                                        <p class="text-success"><b><?= $row['atas_nama'] ?></b></p>
                                        <p>Pembayaran dilakukan langsung di studio.</p>

                                    <?php endif; ?>

                                </div>
                            </div>

                        <?php endwhile; ?>

                    </div>

                    <hr>

                    <div class="alert alert-warning">
                        <b>Catatan:</b> Pastikan nominal pembayaran sesuai tagihan agar verifikasi cepat.
                    </div>

                </div>

                <div class="card-footer text-right">
                    <a href="?page=pembayaran" class="btn btn-primary">Lanjut ke Pembayaran</a>
                </div>
            </div>

        </div>
    </section>
</div>

<script>
function copyToClipboard(elementId) {
    var text = document.getElementById(elementId).innerText;
    navigator.clipboard.writeText(text);

    // Feedback kecil
    Swal.fire({
        toast: true,
        icon: 'success',
        title: 'Nomor berhasil disalin!',
        position: 'top-end',
        showConfirmButton: false,
        timer: 1500
    });
}
</script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
