<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Najwa Record</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>

<style>
    /* 🌟 PERUBAHAN UTAMA: GAYA VIDEO BACKGROUND 🌟 */
    #video-background {
        position: fixed; /* Memastikan video tetap di tempatnya */
        right: 0;
        bottom: 0;
        min-width: 100%; 
        min-height: 100%;
        width: auto;
        height: auto;
        z-index: -100; /* Memastikan video berada di lapisan paling bawah */
        overflow: hidden;
        background-color: #E6E6FA; /* Fallback warna jika video gagal dimuat */
    }

    /* 🌟 LATAR BELAKANG HALAMAN (Body) 🌟 */
    body {
        /* Hapus background-color agar video terlihat */
        background-color: transparent; 
        min-height: 100vh;
        /* Tambahkan warna teks yang kontras dengan video jika video gelap */
        color: #333; 
    }
    
    /* Overlay semi-transparan (Opsional: Disarankan agar teks di atas video lebih mudah dibaca) */
    .content-overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        min-height: 100%;
        background-color: rgba(255, 255, 255, 0.4); /* Putih semi-transparan */
        z-index: -99; /* Di atas video, di bawah konten */
    }

    /* 🎨 PERUBAHAN CARD: Beri background putih semi-transparan agar konten tetap terbaca di atas video */
    .card {
        background-color: rgba(255, 255, 255); /* Putih semi-transparan */
        border: none;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1); 
        border-radius: 15px; 
    }
    
    .card:hover { 
        transform: scale(1.05); 
        transition: 0.3s ease-in-out; 
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.4); 
    }

    /* Gaya Tombol dan Navigasi */
    .btn-primary { border-color: #F54927; background-color: #F54927 !important; }
    .btn-primary:hover { border-color: #c94022; background-color: #c94022 !important; } 
    .navbar-brand:hover,
    .navbar-nav .nav-item a:hover { color: #F54927 !important; }
    
    /* Gaya Gambar */
    .package-image {
        width: 100%; 
        height: auto; 
        max-width: 150px; 
        border-radius: 10px; 
        object-fit: cover; 
        margin-bottom: 10px;
    }
    
    .image-container {
        padding: 10px;
        text-align: center;
    }

    .modal-body {
        text-align: left;
    }
</style>
</head>

<body>
    <video autoplay muted loop id="video-background">
        <source src="vbg2.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <div class="content-overlay"></div>
    <?php
    include_once("database/koneksi.php");
    // ... [Kode PHP JOIN dan query lainnya] ...
    $sql = "
        SELECT 
            p.id, p.nama, p.harga, p.jenis, p.detail, 
            gp.gambar
        FROM 
            tb_paket p
        LEFT JOIN 
            tb_gambar_paket gp ON p.id = gp.id_paket
        ORDER BY 
            p.id DESC;
    ";
    
    $result = $conn->query($sql);
    
    if (!$result) {
        echo '<div class="alert alert-danger text-center">Error saat menjalankan query: ' . $conn->error . '</div>';
        $result = false;
    }
    ?>

    <?php include_once("partials/navbar_portfolio.php"); ?>

    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8 col-xl-6 text-center py-4">
                <h3 style="font-weight: 600;">PAKET PHOTO STUDIO NAJWA RECORD</h3>
            </div>
        </div>

        <div class="row justify-content-center">
            <?php 
            if ($result && $result->num_rows > 0) : 
                while ($row = $result->fetch_assoc()) : 
            ?>
                <div class="col-sm-6 col-md-4 col-lg-3 mb-4">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body text-center">
                            
                            <div class="mb-3 image-container">
                                <?php if (!empty($row['gambar'])): ?>
                                    <img 
                                        src="<?= htmlspecialchars($row['gambar']) ?>" 
                                        alt="<?= htmlspecialchars($row['nama']) ?> Image" 
                                        class="package-image mx-auto d-block"
                                    >
                                <?php else: ?>
                                    <i class="fas fa-camera-retro" style="font-size: 100px; color: #F54927;"></i>
                                <?php endif; ?>
                            </div>

                            <h5 class="card-title fw-bold"><?= htmlspecialchars($row['nama']) ?></h5>
                            <h4 class="card-title fw-bold">
                                <?= isset($row['harga']) ? 'Rp ' . number_format($row['harga'], 0, ',', '.') : 'Data belum diisi' ?>
                            </h4>

                            <p class="card-text"><?= htmlspecialchars($row['detail'] ?? "Data belum diisi") ?></p>
                            <a href="index.php?page=login" class="btn btn-primary mt-2">Pesan Sekarang</a>
                        </div>
                    </div>
                </div>
            <?php 
                endwhile; 
            else: 
            ?>
            <div class="col-12 text-center my-5">
                <p>Tidak ada data paket yang ditemukan.</p>
            </div>
            <?php endif; ?>
        </div>
        
        <hr class="my-5"> 
        
        <?php
        $result_hasil = $conn->query("SELECT * FROM tb_hasil_kerja ORDER BY id DESC");
        ?>
        
        <div class="row justify-content-center">
            <div class="col-12 text-center">
                <h3 style="font-weight: 600;">HASIL KERJA KAMI</h3>
                
                <div class="py-4 row justify-content-center">
                    <?php while ($row_hasil = $result_hasil->fetch_assoc()) : ?>
                        <div class="col-md-6 col-xl-4 mb-3">
                            <iframe 
                                width="100%" 
                                height="350"
                                src="https://www.youtube.com/embed/<?= htmlspecialchars($row_hasil['link_yt']) ?>"
                                title="YouTube video player" 
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                allowfullscreen>
                            </iframe>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    </div>

    <?php include_once("partials/footer_portfolio.php"); ?>
</body>
</html>