<?php include "database/koneksi.php"; ?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Najwa Record</title>

<style>
    body{
        margin:0;
        font-family:Arial, Helvetica, sans-serif;
        background:#f5f5f5;
    }

    /* ====== SECTION LAYANAN ====== */ 
    .section-layanan{
        background:#f5f5f5;
        padding:50px 20px;
        color:black;
    }

    .title-main{
        text-align:center;
        font-size:40px;
        margin-top:10px;
        font-weight:bold;
    }

    .sub-title{
        text-align:center;
        font-size:18px;
        margin-bottom:40px;
    }

    .layanan-container{
        display:flex;
        justify-content:center;
        flex-wrap:wrap;
        gap:35px;
        padding:0 20px;
    }

    .layanan-item{
        width:250px;
        text-align:center;
    }

    .layanan-item img{
        width:100%;
        height:180px;
        object-fit:cover;
        border-radius:4px;
        filter:grayscale(100%);
        border:3px black;
    }

    .layanan-title{
        margin-top:10px;
        font-size:18px;
        font-weight:bold;
        color:black;
    }

    /* ====== SOLUSI BOOKING ====== */
    .section-bawah{
        background:#333;
        color:#fff;
        padding:60px 20px;
        margin-top:0;
    }

    .section-judul{
        text-align:center;
        font-size:26px;
        margin-bottom:40px;
    }

    .box-container{
        display:flex;
        justify-content:center;
        gap:60px;
        flex-wrap:wrap;
    }

    .box{
        width:260px;
        text-align:center;
    }

    .box-icon{
        font-size:60px;
        margin-bottom:10px;
    }

    .box-title{
        font-weight:bold;
        font-size:18px;
        margin-bottom:10px;
    }

    .box-desc{
        font-size:14px;
        line-height:1.4;
    }

    /* ====== TESTIMONI BERJALAN ====== */
    .testimoni-section{
    background:rgba(0, 0, 0, 0); /* Transparan */
    color:#fff;
    padding:20px 0;
    text-align:center;
    overflow:hidden;
    position:relative;
    width:100%;
}


    .testimoni-title{
        font-size:28px;
        font-weight:bold;
        margin-bottom:20px;
    }

    .testimoni-wrapper{
        display:flex;
        gap:20px;
        width:max-content;
        animation: slideLeft 22s linear infinite;
        padding-left:100%;
    }

    @keyframes slideLeft {
        0%   { transform: translateX(0); }
        100% { transform: translateX(-100%); }
    }

    .testimoni-item{
        width:320px;
        text-align:center;
        background:rgba(47, 90, 105);
        padding:20px;
        border-radius:10px;
    }

.testimoni-text{
    font-size:13px;
    line-height:1.5;
    margin-bottom:20px;
    font-style: italic;
}


    .testimoni-foto{
        width:70px;
        height:70px;
        object-fit:cover;
        border-radius:50%;
        margin-bottom:10px;
        border:3px solid #ddd;
    }

    .testimoni-nama{
        font-size:18px;
        font-weight:bold;
        color:#bde2ff;
    }
</style>

</head>
<body>

<!-- ===================== LAYANAN ===================== -->
<div class="section-layanan">

    <div class="title-main">LAYANAN KAMI</div>
    <div class="sub-title">STUDIO POPULER DIGUNAKAN OLEH SEMUA ORANG</div>

    <div class="layanan-container">
    <?php
    $layanan = mysqli_query($conn, "SELECT * FROM tb_layanan ORDER BY id_layanan ASC");
    while($row = mysqli_fetch_assoc($layanan)){ ?>
        <div class="layanan-item">
            <img src="uploads/<?php echo $row['foto']; ?>" alt="<?php echo $row['nama_layanan']; ?>">
            <div class="layanan-title"><?php echo $row['nama_layanan']; ?></div>
        </div>
    <?php } ?>
    </div>

</div> <!-- akhir section-layanan -->

<!-- ===================== SOLUSI BOOKING DINAMIS ===================== -->
<div class="section-bawah">
    <div class="section-judul">ALASAN KENAPA HARUS NAJWA RECORD</div>

    <?php
    // Ambil data alasan + kelebihan dari tb_portfolio_home
    $pf = mysqli_query($conn, "SELECT * FROM tb_portfolio_home WHERE id = 3");
    $p = mysqli_fetch_assoc($pf);
    ?>


    <div class="box-container">

        <div class="box">
            <div class="box-icon">💾</div>
            <div class="box-title">Efisien Waktu</div>
            <div class="box-desc">
                <p align="justify"><?php echo $p['kelebihan1']; ?></p>
            </div>
        </div>

        <div class="box">
            <div class="box-icon">📅</div>
            <div class="box-title">Hemat Biaya</div>
            <div class="box-desc">
                <p align="justify"><?php echo $p['kelebihan2']; ?></p>
            </div>
        </div>

        <div class="box">
            <div class="box-icon">☝️</div>
            <div class="box-title">Paket Terjangkau</div>
            <div class="box-desc">
                <p align="justify"><?php echo $p['kelebihan3']; ?></p>
            </div>
        </div>

        <div class="box">
            <div class="box-icon">👤</div>
            <div class="box-title">Tim Profesional</div>
            <div class="box-desc">
                <p align="justify"><?php echo $p['kelebihan4']; ?></p>
            </div>
        </div>

    </div>
</div>


<!-- ===================== TESTIMONI BERJALAN ===================== -->
<div class="testimoni-section">
    <div class="testimoni-title">TESTIMONI PENGGUNA</div>

    <div class="testimoni-wrapper">
        <?php
        $testi = mysqli_query($conn, "SELECT * FROM tb_testimoni ORDER BY id_testimoni ASC");
        while($t = mysqli_fetch_assoc($testi)){ ?>
            <div class="testimoni-item">
                <p class="testimoni-text">"<?php echo $t['testimoni']; ?>"</p>
                <img src="uploads/<?php echo $t['foto']; ?>" class="testimoni-foto">
                <div class="testimoni-nama"><?php echo $t['nama']; ?></div>
            </div>
        <?php } ?>
    </div>
</div>

</body>
</html>
