<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <title>Najwa Record - Konsep/Tema</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>

<style>
    /* 1. Latar Belakang Halaman (Mengganti gambar set.jpg) */
    body {
        /* Menggunakan latar belakang abu-abu muda yang elegan */
        background-color: #f8f9fa;
        min-height: 100vh;
        color: #333;
    }

    /* 2. Warna Aksen (Merah-Oranye Energik) */
    .btn-primary {
        border-color: #F54927;
        background-color: #F54927 !important;
        font-weight: 600;
    }

    .btn-primary:hover {
        border-color: #c94022;
        background-color: #c94022 !important;
    }

    h3 {
        color: #F54927; /* Judul utama menggunakan warna aksen */
        font-weight: 700 !important;
        margin-bottom: 30px;
    }

    /* 3. Styling Kartu Konsep (Mengganti div dengan card untuk estetika) */
    .konsep-card {
        background-color: #ffffff; /* Latar belakang putih */
        border: none;
        border-radius: 15px; /* Sudut membulat */
        padding: 20px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
        transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
        cursor: pointer;
        height: 100%; /* Memastikan tinggi sama */
    }

    .konsep-card:hover {
        transform: translateY(-5px); /* Efek mengangkat */
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }
    
    /* 4. Efek Zoom pada Gambar Dihapus, diganti dengan efek hover pada card */
    .konsep-image {
        height: 150px; /* Ukuran gambar melingkar yang konsisten */
        aspect-ratio: 1/1;
        object-fit: cover;
        border: 4px solid #F54927; /* Border warna aksen */
        padding: 5px; /* Jarak antara gambar dan border */
    }

    .konsep-title {
        font-weight: 600;
        margin-top: 15px;
        color: #333;
    }
    
    .modal-body {
        text-align: left;
    }
    
    .modal-body img {
        display: block;
        margin: auto;
        max-width: 100%;
        height: auto;
        border-radius: 10px; /* Sudut gambar di modal */
        margin-bottom: 15px;
    }
</style>
</head>

<body>
    <?php
    // Tambahkan debugging sementara di sini jika Anda mengalami error
    // ini_set('display_errors', 1); error_reporting(E_ALL); 
    include_once("database/koneksi.php");
    ?>
    <?php include_once("partials/navbar_portfolio.php"); ?>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-12 text-center mb-4">
                <h3>KONSEP/TEMA</h3>
            </div>
        </div>
        
        <?php
        // Query untuk mengambil satu gambar per konsep
        $sql_konsep = "
            SELECT 
                tk.id, tk.nama, tk.detail, 
                tgk.gambar
            FROM 
                tb_konsep tk 
            INNER JOIN 
                tb_gambar_konsep tgk ON tgk.id_konsep=tk.id
            GROUP BY 
                tk.id
            ORDER BY
                tk.id ASC;
        ";
        $result = $conn->query($sql_konsep);

        if (!$result) {
            echo '<div class="alert alert-danger text-center">Error saat mengambil data konsep: ' . $conn->error . '</div>';
            $result = false;
        }
        ?>
        
        <div class="row text-center justify-content-center">
            <?php 
            if ($result && $result->num_rows > 0) : 
                while ($row = $result->fetch_assoc()) : 
            ?>
                <div class="col-6 col-md-4 col-lg-3 mb-4">
                    <div 
                        class="konsep-card shadow-sm"
                        data-bs-toggle="modal" 
                        data-bs-target="#konsep_<?= $row['id'] ?>"
                    >
                        <img 
                            src="<?= htmlspecialchars($row['gambar']) ?>" 
                            alt="<?= htmlspecialchars($row['nama']) ?>" 
                            class="rounded-circle konsep-image mx-auto d-block"
                        >
                        <h5 class="konsep-title"><?= htmlspecialchars($row['nama']) ?></h5>
                    </div>
                </div>

                <div class="modal fade" id="konsep_<?= $row['id'] ?>" tabindex="-1" aria-labelledby="konsepModalLabel_<?= $row['id'] ?>" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content">
                            <div class="modal-header bg-light">
                                <h5 class="modal-title" id="konsepModalLabel_<?= $row['id'] ?>" style="color: #F54927; font-weight: 700;">
                                    <?= htmlspecialchars($row['nama']) ?>
                                </h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body p-4">
                                <img src="<?= htmlspecialchars($row['gambar']) ?>" alt="Gambar <?= htmlspecialchars($row['nama']) ?>" class="img-fluid rounded-3">
                                
                                <h6 class="text-start" style="font-weight: 600; color: #333;">Deskripsi:</h6>

                                <div class="text-start" style="color: #555;">
                                    <?= html_entity_decode($row['detail']) ?>
                                </div>


                                
                                <div class="text-center mt-4">
                                    <a href="konsep.php" class="btn btn-primary">Lihat Paket Konsep Lain</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; 
            else: ?>
                <div class="col-12 text-center mt-4">
                    <p class="text-muted">Belum ada data konsep yang tersedia.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php include_once("partials/footer_portfolio.php"); ?>
</body>
</html>