<?php
session_start();
include "../../database/koneksi.php";
?>

<div class="content-wrapper">

<section class="content">
<div class="container-fluid">
<div class="row">
<div class="col-12">

<div class="card mt-3">

    <div class="card-header d-flex align-items-center">
        <h4 class="flex-grow-1 m-0 font-weight-bold">Data Jadwal Pengambilan</h4>

        <?php if ($_SESSION['level'] == 'ADMIN'): ?>
            <a href="?page=tambah_jadwal_pengambilan" class="btn btn-primary">
                Tambah
            </a>
        <?php endif; ?>
    </div>

    <style>
        .small-td { width: 1%; white-space: nowrap; }
        .badge-status {
            padding: 5px 10px;
            border-radius: 10px;
            font-size: 0.85rem;
            font-weight: 600;
        }
        .badge-belum { background: #ffc107; color: #000; }
        .badge-dijadwalkan { background: #17a2b8; color: #fff; }
        .badge-selesai { background: #28a745; color: #fff; }
    </style>

    <div class="card-body">
        <table id="example2" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th class="text-center">No</th>
                    <th class="text-center">Nama Klien</th>
                    <th class="text-center">Invoice</th>
                    <th class="text-center">Tanggal Pengambilan</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">Catatan</th>
                    <?php if ($_SESSION['level'] == 'ADMIN'): ?>
                        <th class="text-center small-td">Aksi</th>
                    <?php endif; ?>
                </tr>
            </thead>

            <tbody>
                <?php
                $no = 1;

                $is_client = (isset($_SESSION['level']) && $_SESSION['level'] === 'KLIEN');
                $id_klien = $is_client ? intval($_SESSION['id_klien']) : null;

                $sql = "
                    SELECT 
                        jp.id,
                        jp.jadwal_pengambilan_1,
                        jp.catatan,
                        jp.status,
                        p.invoice,
                        k.nama_lengkap
                    FROM tb_jadwal_pengambilan jp
                    INNER JOIN tb_pengajuan p ON p.id = jp.id_pengajuan
                    INNER JOIN tb_klien k ON k.id = p.id_klien
                ";

                if ($is_client) {
                    $sql .= " WHERE k.id = $id_klien ";
                }

                $sql .= " ORDER BY jp.jadwal_pengambilan_1 IS NULL, jp.jadwal_pengambilan_1 DESC";

                $result = $conn->query($sql);

                $bulan = [
                    "Januari","Februari","Maret","April","Mei","Juni",
                    "Juli","Agustus","September","Oktober","November","Desember"
                ];

                while ($row = $result->fetch_assoc()):
                ?>
                <tr>
                    <td class="text-center"><?= $no++ ?></td>

                    <td class="text-center"><?= htmlspecialchars($row['nama_lengkap']) ?></td>

                    <td class="text-center"><?= htmlspecialchars($row['invoice']) ?></td>

                    <td class="text-center">
                        <?php
                        $tgl = $row['jadwal_pengambilan_1'];
                        if (!empty($tgl) && $tgl !== "0000-00-00") {
                            $d = explode("-", $tgl);
                            $format = intval($d[2]) . " " . $bulan[intval($d[1]) - 1] . " " . $d[0];

                            echo '<a href="?page=edit_jadwal_pengambilan&id=' . $row['id'] . '">'
                                . $format .
                                '</a>';
                        } else {
                            if ($_SESSION['level'] == 'ADMIN') {
                                echo '<a href="?page=edit_jadwal_pengambilan&id=' . $row['id'] . '" class="text-primary">
                                        Tentukan Tanggal
                                      </a>';
                            } else {
                                echo '<span class="text-muted">Belum ditentukan</span>';
                            }
                        }
                        ?>
                    </td>

                    <td class="text-center">
                        <?php
                        $status = $row['status'];
                        $class = "badge-belum";

                        if ($status == "DIJADWALKAN") $class = "badge-dijadwalkan";
                        if ($status == "SELESAI") $class = "badge-selesai";

                        echo "<span class='badge-status $class'>$status</span>";
                        ?>
                    </td>

                    <td><?= !empty($row['catatan']) ? htmlspecialchars($row['catatan']) : '-' ?></td>

                    <?php if ($_SESSION['level'] == 'ADMIN'): ?>
                    <td class="text-center small-td">
                        <a href="?page=edit_jadwal_pengambilan&id=<?= $row['id'] ?>"
                           class="btn btn-sm btn-warning">Edit</a>

                        <form action="?page=hapus_jadwal_pengambilan&id=<?= $row['id'] ?>"
                              method="POST" class="d-inline"
                              onsubmit="return confirm('Hapus data ini?');">
                            <button class="btn btn-sm btn-danger" type="submit">Hapus</button>
                        </form>
                    </td>
                    <?php endif; ?>
                </tr>
                <?php endwhile; ?>
            </tbody>

        </table>
    </div>
</div>

</div>
</div>
</div>
</section>

</div>

<script>
$(function () {
    $('#example2').DataTable({
        responsive: true,
        autoWidth: false,
        searching: true,
    });
});
</script>
