<?php
session_start();
include "../../database/koneksi.php";
include "MailSender.php";

// Hanya ADMIN
if ($_SESSION['level'] !== 'ADMIN') {
    echo "<script>alert('Akses ditolak!'); window.location.href='?page=jadwal_pengambilan';</script>";
    exit;
}

$pengajuan = $conn->query("
    SELECT p.id, p.invoice, k.nama_lengkap, k.email 
    FROM tb_pengajuan p
    INNER JOIN tb_klien k ON k.id = p.id_klien
    WHERE p.status = 'DISETUJUI'
    AND p.id NOT IN (
        SELECT id_pengajuan FROM tb_jadwal_pengambilan
    )
")->fetch_all(MYSQLI_ASSOC);


if (isset($_POST['simpan'])) {
    $id_pengajuan = intval($_POST['id_pengajuan']);
    $tanggal = $_POST['jadwal_pengambilan_1'];
    $catatan = $_POST['catatan'];

    $stmt = $conn->prepare("
        INSERT INTO tb_jadwal_pengambilan (id_pengajuan, jadwal_pengambilan_1, catatan, status)
        VALUES (?, ?, ?, 'DIJADWALKAN')
    ");
    $stmt->bind_param("iss", $id_pengajuan, $tanggal, $catatan);
    $stmt->execute();

    // Ambil email klien
    $q = $conn->query("
        SELECT k.email 
        FROM tb_pengajuan p
        INNER JOIN tb_klien k ON k.id = p.id_klien
        WHERE p.id = $id_pengajuan
    ")->fetch_assoc();

    // Kirim Email Notifikasi
    $body = "Jadwal pengambilan Anda telah ditentukan pada tanggal <b>$tanggal</b>.<br>Catatan: $catatan";
    new MailSender($q['email'], "PENGAMBIAN", $body, "Jadwal Pengambilan Ditentukan");

    echo "<script>
            alert('Data berhasil ditambahkan!');
            window.location.href='?page=jadwal_pengambilan';
          </script>";
    exit;
}
?>

<div class="content-wrapper">
<section class="content">
<div class="container-fluid">
<div class="row">
<div class="col-md-8 mx-auto">

<div class="card mt-4">
    <div class="card-header">
        <h4 class="m-0 font-weight-bold">Tambah Jadwal Pengambilan</h4>
    </div>

    <form method="POST">
        <div class="card-body">

            <div class="form-group">
                <label>Pilih Pengajuan</label>
                <select name="id_pengajuan" class="form-control" required>
                    <option value="">-- Pilih --</option>
                    <?php foreach ($pengajuan as $p): ?>
                        <option value="<?= $p['id'] ?>">
                            <?= $p['invoice'] ?> - <?= $p['nama_lengkap'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="form-group">
                <label>Tanggal Pengambilan</label>
                <input type="date" name="jadwal_pengambilan_1" class="form-control" required>
            </div>

            <div class="form-group">
                <label>Catatan</label>
                <textarea name="catatan" class="form-control" rows="3"></textarea>
            </div>

        </div>

        <div class="card-footer">
            <button type="submit" name="simpan" class="btn btn-primary">Simpan</button>
            <a href="?page=jadwal_pengambilan" class="btn btn-secondary">Kembali</a>
        </div>
    </form>
</div>

</div>
</div>
</div>
</section>
</div>
