<?php
session_start();
include "../../database/koneksi.php";
include "MailSender.php";

if ($_SESSION['level'] !== 'ADMIN') {
    echo "<script>alert('Akses ditolak!'); window.location.href='?page=jadwal_pengambilan';</script>";
    exit;
}

$id = intval($_GET['id']);
$data = $conn->query("
    SELECT jp.*, p.invoice, k.email, k.nama_lengkap
    FROM tb_jadwal_pengambilan jp
    INNER JOIN tb_pengajuan p ON p.id = jp.id_pengajuan
    INNER JOIN tb_klien k ON k.id = p.id_klien
    WHERE jp.id = $id
")->fetch_assoc();

if (!$data) {
    echo "<script>alert('Data tidak ditemukan'); window.location.href='?page=jadwal_pengambilan';</script>";
    exit;
}

if (isset($_POST['update'])) {
    $tanggal = $_POST['jadwal_pengambilan_1'];
    $catatan = $_POST['catatan'];
    $status = $_POST['status'];

    $stmt = $conn->prepare("
        UPDATE tb_jadwal_pengambilan 
        SET jadwal_pengambilan_1=?, catatan=?, status=?
        WHERE id=?
    ");
    $stmt->bind_param("sssi", $tanggal, $catatan, $status, $id);
    $stmt->execute();

    // Kirim email perubahan
    $body = "
        Jadwal pengambilan Anda telah UPDATE ke:<br>
        <b>$tanggal</b><br>
        Status: <b>$status</b><br>
        Catatan: $catatan
    ";
    new MailSender($data['email'], "PENGAMBILAN", $body, "Update Jadwal Pengambilan");

    echo "<script>
            alert('Data berhasil diperbarui!');
            window.location.href='?page=jadwal_pengambilan';
          </script>";
    exit;
}
?>

<div class="content-wrapper">
<section class="content">
<div class="container-fluid">
<div class="row">
<div class="col-md-8 mx-auto">

<div class="card mt-4">
    <div class="card-header">
        <h4 class="m-0 font-weight-bold">Ubah Jadwal Pengambilan</h4>
    </div>

    <form method="POST">
        <div class="card-body">

            <div class="form-group">
                <label>Invoice</label>
                <input type="text" class="form-control" value="<?= $data['invoice'] ?>" disabled>
            </div>

            <div class="form-group">
                <label>Tanggal Pengambilan</label>
                <input type="date" name="jadwal_pengambilan_1" class="form-control"
                       value="<?= $data['jadwal_pengambilan_1'] ?>" required>
            </div>

            <div class="form-group">
                <label>Status</label>
                <select name="status" class="form-control" required>
                    <option value="BELUM" <?= $data['status'] == 'BELUM' ? 'selected' : '' ?>>BELUM</option>
                    <option value="DIJADWALKAN" <?= $data['status'] == 'DIJADWALKAN' ? 'selected' : '' ?>>DIJADWALKAN</option>
                    <option value="SELESAI" <?= $data['status'] == 'SELESAI' ? 'selected' : '' ?>>SELESAI</option>
                </select>
            </div>

            <div class="form-group">
                <label>Catatan</label>
                <textarea name="catatan" class="form-control"><?= $data['catatan'] ?></textarea>
            </div>

        </div>

        <div class="card-footer">
            <button type="submit" name="update" class="btn btn-primary">Update</button>
            <a href="?page=jadwal_pengambilan" class="btn btn-secondary">Kembali</a>
        </div>
    </form>

</div>

</div>
</div>
</div>
</section>
</div>
