<?php
date_default_timezone_set("Asia/Kuala_Lumpur");
session_start();
include_once('database/koneksi.php');
include_once('utils/tanggal.php');

if (isset($_SESSION['id'])) {
    include_once('partials/header.php');
    include_once('partials/navbar.php');
    
    // Sidebar berdasarkan level
    if ($_SESSION['level'] === 'ADMIN') {
        include_once('partials/sidebar_admin.php');
    } else if ($_SESSION['level'] === 'KLIEN') {
        include_once('partials/sidebar_klien.php');
    }

    // Menentukan halaman berdasarkan parameter 'page'
    if (isset($_GET['page'])) {
        switch ($_GET['page']) {
            // Master Data Konsep
            case 'konsep':
                include_once('master_data/konsep/tampil.php');
                break;
            case 'tambah_konsep':
                include_once('master_data/konsep/tambah.php');
                break;
            case 'edit_konsep':
                include_once('master_data/konsep/edit.php');
                break;
            case 'hapus_konsep':
                include_once('master_data/konsep/hapus.php');
                break;
            case 'detail_konsep':
                include_once('master_data/konsep/detail.php');
                break;
            case 'laporan_konsep':
                include_once('master_data/konsep/laporan.php');
                break;
            

            // Master Data Jabatan
            case 'jabatan':
                include_once('master_data/jabatan/tampil.php');
                break;
            case 'tambah_jabatan':
                include_once('master_data/jabatan/tambah.php');
                break;
            case 'edit_jabatan':
                include_once('master_data/jabatan/edit.php');
                break;
            case 'hapus_jabatan':
                include_once('master_data/jabatan/hapus.php');
                break;


            // Master Data Bank
            case 'bank':
                include_once('master_data/bank/tampil.php');
                break;
            case 'tambah_bank':
                include_once('master_data/bank/tambah.php');
                break;
            case 'edit_bank':
                include_once('master_data/bank/edit.php');
                break;
            case 'hapus_bank':
                include_once('master_data/bank/hapus.php');
                break;
            case 'detail_bank':
                include_once('master_data/bank/detail.php');
                break;
            case 'laporan_bank':
                include_once('master_data/bank/laporan.php');
                break;

            // Master Data Paket
            case 'paket':
                include_once('master_data/paket/tampil.php');
                break;
            case 'tambah_paket':
                include_once('master_data/paket/tambah.php');
                break;
            case 'edit_paket':
                include_once('master_data/paket/edit.php');
                break;
            case 'hapus_paket':
                include_once('master_data/paket/hapus.php');
                break;
            case 'detail_paket':
                include_once('master_data/paket/detail.php');
                break;
            case 'laporan_paket':
                include_once('master_data/paket/laporan.php');
                break;

            // Pengajuan
            case 'pengajuan':
                include_once('pengajuan/tampil.php');
                break;
            case 'tambah_pengajuan':
                include_once('pengajuan/tambah.php');
                break;
            case 'edit_pengajuan':
                include_once('pengajuan/edit.php');
                break;
            case 'detail_pengajuan':
                include_once('pengajuan/detail.php');
                break;
            case 'hapus_pengajuan':
                include_once('pengajuan/hapus.php');
                break;
            case 'laporan_pengajuan':
                include_once('pengajuan/laporan.php');
                break;
            case 'tolak_pengajuan':
                include_once('pengajuan/tolak.php');
                break;
            case 'setujui_pengajuan':
                include_once('pengajuan/setujui.php');
                break;

            // Anggaran
            case 'anggaran':
                include_once('anggaran/tampil.php');
                break;
            case 'tambah_anggaran':
                include_once('anggaran/tambah.php');
                break;
            case 'edit_anggaran':
                include_once('anggaran/edit.php');
                break;
            case 'detail_anggaran':
                include_once('anggaran/detail.php');
                break;
            case 'hapus_anggaran':
                include_once('anggaran/hapus.php');
                break;
            case 'laporan_anggaran':
                include_once('anggaran/laporan.php');
                break;

            // Pembayaran
            case 'cara_pembayaran':
                include_once('partials/cabay.php');
                break;                
            case 'pembayaran':
                include_once('pembayaran/tampil.php');
                break;
            case 'tambah_pembayaran':
                include_once('pembayaran/tambah.php');
                break;
            case 'edit_pembayaran':
                include_once('pembayaran/edit.php');
                break;
            case 'detail_pembayaran':
                include_once('pembayaran/detail.php');
                break;
            case 'hapus_pembayaran':
                include_once('pembayaran/hapus.php');
                break;
            case 'laporan_pembayaran':
                include_once('pembayaran/laporan.php');
                break;

            // Jadwal Pengambilan
            case 'jadwal_pengambilan':
                include_once('jadwal_pengambilan/tampil.php');
                break;
            case 'tambah_jadwal_pengambilan':
                include_once('jadwal_pengambilan/tambah.php');
                break;
            case 'edit_jadwal_pengambilan':
                include_once('jadwal_pengambilan/edit.php');
                break;
            case 'hapus_jadwal_pengambilan':
                include_once('jadwal_pengambilan/hapus.php');
                break;

            // Klien
            case 'klien':
                include_once('data_klien/tampil.php');
                break;
            case 'tambah_klien':
                include_once('data_klien/tambah.php');
                break;
            case 'edit_klien':
                include_once('data_klien/edit.php');
                break;
            case 'hapus_klien':
                include_once('data_klien/hapus.php');
                break;
            case 'laporan_klien':
                include_once('data_klien/laporan.php');
                break;

            // Karyawan
            case 'karyawan':
                include_once('data_karyawan/tampil.php');
                break;
            case 'tambah_karyawan':
                include_once('data_karyawan/tambah.php');
                break;
            case 'edit_karyawan':
                include_once('data_karyawan/edit.php');
                break;
            case 'hapus_karyawan':
                include_once('data_karyawan/hapus.php');
                break;
            case 'laporan_karyawan':
                include_once('data_karyawan/laporan.php');
                break;

            // Portfolio
            case 'caraousel':
                include_once('portfolio/home/caraousel/tampil.php');
                break;
            case 'tambah_caraousel':
                include_once('portfolio/home/caraousel/tambah.php');
                break;
            case 'edit_caraousel':
                include_once('portfolio/home/caraousel/edit.php');
                break;
            case 'hapus_caraousel':
                include_once('portfolio/home/caraousel/hapus.php');
                break;
            case 'paket_wedding':
                include_once('portfolio/home/paket_wedding/tampil.php');
                break;
            case 'tambah_paket_wedding':
                include_once('portfolio/home/paket_wedding/tambah.php');
                break;
            case 'edit_paket_wedding':
                include_once('portfolio/home/paket_wedding/edit.php');
                break;
            case 'hapus_paket_wedding':
                include_once('portfolio/home/paket_wedding/hapus.php');
                break;
            case 'hasil_kerja':
                include_once('portfolio/home/hasil_kerja/tampil.php');
                break;
            case 'tambah_hasil_kerja':
                include_once('portfolio/home/hasil_kerja/tambah.php');
                break;
            case 'edit_hasil_kerja':
                include_once('portfolio/home/hasil_kerja/edit.php');
                break;
            case 'hapus_hasil_kerja':
                include_once('portfolio/home/hasil_kerja/hapus.php');
                break;
            case 'profil':
                include_once('portfolio/home/profil/profil.php');
                break;
            case 'alasan_pengguna':
                include_once('portfolio/home/alasan_pengguna/alasan_pengguna.php');
                break;
            case 'kelebihan':
                include_once('portfolio/home/kelebihan/kelebihan.php');
                break;

            // Vendor
            case 'profil_vendor':
                include_once('portfolio/vendor/profil_vendor/profil_vendor.php');
                break;
            case 'vendor_terbaik':
                include_once('portfolio/vendor/vendor_terbaik/vendor_terbaik.php');
                break;

            // Crew
            case 'profil_crew':
                include_once('portfolio/crew/profil_crew/profil_crew.php');
                break;

            // Testimoni
            case 'testimoni':
                include_once('testimoni/tampil.php');
                break;
            case 'tambah_testimoni':
                include_once('testimoni/tambah.php');
                break;
            case 'edit_testimoni':
                include_once('testimoni/edit.php');
                break;
            case 'hapus_testimoni':
                include_once('testimoni/hapus.php');
                break;
                                
            // Latihan
            case 'latihan':
                include_once('data_latihan/tampil.php');
                break;
            case 'tambah_latihan':
                include_once('data_latihan/tambah.php');
                break;
            case 'edit_latihan':
                include_once('data_latihan/edit.php');
                break;
            case 'hapus_latihan':
                include_once('data_latihan/hapus.php');
                break;

            // Latihan Relasi
            case 'latihan_relasi':
                include_once('master_data/latihan/tampil.php');
                break;
            case 'tambah_latihan_relasi':
                include_once('master_data/latihan/tambah.php');
                break;
            case 'edit_latihan_relasi':
                include_once('master_data/latihan/edit.php');
                break;
            case 'hapus_latihan_relasi':
                include_once('master_data/latihan/hapus.php');
                break;

            // Default: Dashboard
            default:
                include_once('dashboard.php');
        }
    } else {
        include_once('dashboard.php');
    }
    
    include_once('partials/footer.php');
} else {
    // Jika belum login, tampilkan halaman login/register
    if (isset($_GET['page'])) {
        switch ($_GET['page']) {
            case 'register':
                include_once("halaman_auth/register.php");
                break;
            case 'verif':
                include_once("halaman_auth/verif.php");
                break;
            default:
                include_once("halaman_auth/login.php");
        }
        exit;
    }
    header('Location: portfolio.php');
    exit;
}
?>
