<?php
session_start();
include_once('database/koneksi.php');

// --- DATA DASHBOARD ---

// Pengajuan Pending (khusus admin)
$jml_pengajuan_baru = 0;
if ($_SESSION['level'] == 'ADMIN') {
    $q = $conn->query("SELECT COUNT(*) AS jml FROM tb_pengajuan WHERE status='Pending'");
    $jml_pengajuan_baru = $q->fetch_assoc()['jml'];
}

// Total Klien
$q = $conn->query("SELECT COUNT(*) AS jml FROM tb_klien");
$jml_klien = $q->fetch_assoc()['jml'];

// Total Karyawan
$q = $conn->query("SELECT COUNT(*) AS jml FROM tb_karyawan");
$jml_karyawan = $q->fetch_assoc()['jml'];

// Total Paket
$q = $conn->query("SELECT COUNT(*) AS jml FROM tb_paket");
$jml_paket = $q->fetch_assoc()['jml'];

// TOTAL PENDAPATAN SUKSES
$q = $conn->query("
    SELECT SUM(t.total) AS total_pendapatan FROM (
        SELECT (tp.harga + ta.anggaran_tambahan) AS total
        FROM tb_pengajuan ts
        INNER JOIN tb_anggaran ta ON ts.id = ta.id_pengajuan
        INNER JOIN tb_paket tp ON ts.dokumentasi = tp.id
        LEFT JOIN tb_pembayaran tb ON ta.id = tb.id_anggaran
        WHERE tb.status = 'Terverifikasi'
    ) t
");
$total_pendapatan = $q->fetch_assoc()['total_pendapatan'] ?? 0;

// DATA UNTUK CHART
$chart_labels = ['Total Klien', 'Total Karyawan', 'Total Paket'];
$chart_data = [$jml_klien, $jml_karyawan, $jml_paket];
$chart_colors = ['#28a745','#ffc107','#dc3545'];

if ($_SESSION['level'] == 'ADMIN') {
    $chart_labels[] = 'Pending';
    $chart_data[] = $jml_pengajuan_baru;
    $chart_colors[] = '#17a2b8';
}
?>

<!-- STYLE CUSTOM -->
<style>
.dashboard-title {
    font-size: 30px;
    font-weight: 700;
    color: white;
}
.dashboard-box {
    background: rgba(255,255,255,0.1);
    padding: 25px;
    border-radius: 16px;
    backdrop-filter: blur(12px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.25);
}
.info-modern {
    border-radius: 16px;
    color: white;
    box-shadow: 0 8px 20px rgba(0,0,0,0.25);
}
.content-wrapper {
    background: linear-gradient(135deg, #1e1e2f, #2a2a40);
    padding-bottom: 50px;
}
</style>

<!-- DASHBOARD -->
<div class="content-wrapper">

    <div class="content-header">
        <div class="container-fluid">
            <h1 class="dashboard-title">
                <i class="fas fa-tachometer-alt text-warning mr-2"></i>
                Dashboard  
                <span style="font-size: 18px; font-weight: 400;">
                    | Selamat Datang, <?= ($_SESSION['level']=="ADMIN")?"Admin":$_SESSION['nama']; ?>
                </span>
            </h1>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">

            <!-- TOTAL PENDAPATAN -->
            <div class="dashboard-box mb-4">
                <h4 class="text-warning m-0">TOTAL PENDAPATAN SUCCESS</h4>
                <h1 class="text-white mt-2" style="font-size: 46px; font-weight: 700;">
                    Rp. <?= number_format($total_pendapatan,0,",","."); ?>
                </h1>
            </div>

            <!-- 4 INFO BOX -->
            <div class="row">

                <?php if ($_SESSION['level']=="ADMIN"): ?>
                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="info-box info-modern bg-info">
                        <span class="info-box-icon"><i class="fa fa-paper-plane"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Pending</span>
                            <span class="info-box-number" style="font-size: 28px; font-weight: 700;">
                                <?= $jml_pengajuan_baru ?>
                            </span>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="info-box info-modern bg-success">
                        <span class="info-box-icon"><i class="fas fa-users"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Klien</span>
                            <span class="info-box-number" style="font-size: 28px; font-weight: 700;">
                                <?= $jml_klien ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="info-box info-modern bg-warning">
                        <span class="info-box-icon"><i class="fas fa-user-tie"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Karyawan</span>
                            <span class="info-box-number" style="font-size: 28px; font-weight: 700;">
                                <?= $jml_karyawan ?>
                            </span>
                        </div>
                    </div>
                </div>

                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="info-box info-modern bg-danger">
                        <span class="info-box-icon"><i class="fas fa-cubes"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Paket</span>
                            <span class="info-box-number" style="font-size: 28px; font-weight: 700;">
                                <?= $jml_paket ?>
                            </span>
                        </div>
                    </div>
                </div>

            </div>

            <!-- CHART -->
            <div class="card shadow-lg" style="border-radius: 16px;">
                <div class="card-header bg-primary" style="border-radius: 16px 16px 0 0;">
                    <h3 class="card-title text-white">
                        <i class="fas fa-chart-bar mr-2"></i> Statistik Keseluruhan
                    </h3>
                </div>
                <div class="card-body bg-white">
                    <canvas id="barChart" style="height: 350px;"></canvas>
                </div>
            </div>

        </div>
    </section>
</div>

<!-- CHART SCRIPT -->
<script>
$(function () {

    var chartLabels = <?= json_encode($chart_labels); ?>;
    var chartData = <?= json_encode($chart_data); ?>;
    var chartColors = <?= json_encode($chart_colors); ?>;

    var ctx = $('#barChart').get(0).getContext('2d');

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartLabels,
            datasets: [{
                backgroundColor: chartColors,
                borderColor: chartColors,
                borderWidth: 1,
                data: chartData
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: { display: false },
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        callback: function(value){ if(value % 1 === 0) return value; }
                    }
                }]
            }
        }
    });

});
</script>
