<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="assets/plugins/fontawesome-free/css/all.min.css">
    <title>Najwa Record</title>

    <style>
        /* ==================================== */
        /* CSS Umum dan Background */
        /* ==================================== */
        body {
            background-image: url("set.jpg");
            background-attachment: fixed;
            background-size: cover;
            background-position: center;
            margin: 0;
            padding: 0;
        }

        #video-bg {
            position: fixed;
            right: 0;
            bottom: 0;
            min-width: 100%;
            min-height: 100%;
            z-index: -1;
            object-fit: cover;
            filter: brightness(80%);
        }

        /* Tautan */
        a {
            text-decoration: none;
            color: inherit;
        }
        
        a:hover {
            color: #e64900;
        }

        /* ==================================== */
        /* CSS untuk ID Card Kru */
        /* ==================================== */

        .id-card {
            display: flex;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            overflow: hidden;
            height: 250px;
            width: 100%;
            transition: transform 0.3s ease;
            cursor: pointer; /* Menandakan bahwa kartu bisa diklik */
        }

        .id-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        }

        /* Bagian Foto (Kiri) */
        .id-card-photo {
            flex: 0 0 40%;
            overflow: hidden;
        }
        
        .id-card-photo .clickable-area {
            display: block;
            width: 100%;
            height: 100%;
        }

        .id-card-photo img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        
        .id-card-photo .clickable-area:hover img {
            transform: scale(1.05);
        }

        /* Header Oranye */
        .id-card-header {
            background-color: #ff5100;
            color: white;
            padding: 10px;
            text-align: center;
            min-height: 70px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        /* ... CSS lainnya sama seperti sebelumnya ... */
        
        .id-card-name {
            font-size: 1.1rem;
            font-weight: 900;
            line-height: 1.1;
            color: #ff5100;
            text-transform: uppercase;
            margin-bottom: 3px;
        }

        .id-card-name small {
            font-size: 1rem;
            color: #333;
            font-weight: 600;
            display: block;
        }
        
        .id-card-details {
            padding: 15px 15px 10px 15px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        
        /* CSS untuk Modal */
        .modal-header-custom {
            background-color: #ff5100;
            color: white;
            border-bottom: none;
            padding: 1rem;
        }
        
        .modal-body-content {
            display: flex;
            padding: 20px;
        }
        
        .modal-crew-photo {
            flex: 0 0 40%;
            max-width: 40%;
        }
        
        .modal-crew-photo img {
            width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .modal-crew-details {
            flex: 1;
            padding-left: 20px;
        }
        
        .modal-crew-details h3 {
            color: #ff5100;
            font-weight: 900;
        }
        
        /* Responsif Modal */
        @media (max-width: 768px) {
            .id-card {
                height: auto;
                flex-direction: column;
            }

            .id-card-photo {
                flex: none;
                width: 100%;
                height: 200px;
            }
            
            .modal-body-content {
                flex-direction: column;
                text-align: center;
            }
            
            .modal-crew-photo {
                max-width: 100%;
                margin-bottom: 15px;
            }
            
            .modal-crew-details {
                padding-left: 0;
            }
        }
        
    </style>
</head>

<body>
    <video autoplay muted loop id="video-bg">
        <source src="vbg.mp4" type="video/mp4">
    </video>

    <?php
    include_once("database/koneksi.php");
    
    // --- QUERY DATA ---
    $result_portfolio = $conn->query("SELECT * FROM tb_portfolio_crew");
    $data_portfolio = $result_portfolio->fetch_assoc();
    
    $result_karyawan = $conn->query("
        SELECT tb_karyawan.*, tb_jabatan.nama AS nama_jabatan
        FROM tb_karyawan 
        LEFT JOIN tb_jabatan ON tb_jabatan.id = tb_karyawan.id_jabatan
    ");

    $items = [];
    while ($row = $result_karyawan->fetch_assoc()) {
        $items[] = $row;
    }
    // --- END QUERY DATA ---
    ?>

    <?php include_once("partials/navbar_portfolio.php"); ?>

    <div class="container-fluid p-0">
        <div class="row g-0 justify-content-center p-4" style="background-color: rgba(245, 245, 247, 0.8);">
            <div class="col-sm-8 col-md-8 col-lg-6 text-center">
                <h4 style="font-weight: bold;">TIM NAJWA RECORD</h4>
                <br>
                <p style="font-weight: bold; font-size: 1.2rem;"><?= $data_portfolio['prinsip_kami'] ?? 'Prinsip kami adalah menciptakan karya dengan hati dan profesionalitas tinggi.' ?></p>
            </div>
        </div>
    </div>
    
    <div class="container py-5">
        
    
        <div class="row justify-content-center">
    
            <?php if (count($items) > 0): ?>
                <?php foreach ($items as $crew): ?>
                    
                    <div class="col-lg-4 col-md-6 col-sm-12 mb-4">
                        <div class="id-card" 
                            data-bs-toggle="modal" 
                            data-bs-target="#crewDetailModal"
                            data-nama="<?= $crew['nama'] ?>"
                            data-jabatan="<?= $crew['nama_jabatan'] ?? 'Jabatan Tidak Diketahui' ?>"
                            data-foto="<?= !empty($crew['foto']) ? $crew['foto'] : 'assets/img/placeholder.jpg' ?>"
                            data-telp="<?= $crew['no_telp'] ?? 'Tidak Ada No. Telp' ?>"
                            data-alamat="<?= $crew['alamat'] ?? 'Studio Najwa Record' ?>"
                            data-tgl-lahir="<?= !empty($crew['tanggal_lahir']) ? date('d F Y', strtotime($crew['tanggal_lahir'])) : 'Aktif' ?>"
                            data-deskripsi="<?= $crew['deskripsi'] ?? 'Deskripsi profil belum tersedia.' ?>"
                        >
                            <div class="id-card-photo">
                                <span class="clickable-area">
                                    <img src="<?= !empty($crew['foto']) ? $crew['foto'] : 'assets/img/placeholder.jpg' ?>" alt="<?= $crew['nama'] ?>">
                                </span>
                            </div>
                            
                            <div class="id-card-info">
                                
                                <div class="id-card-header">
                                    <div class="logo-icon">
                                        <i class="fas fa-arrow-up"></i> 
                                    </div>
                                    <div class="logo-text">NAJWA RECORD</div>
                                </div>
        
                                <div class="id-card-details">
                                    <div>
                                        <span class="text-decoration-none">
                                            <div class="id-card-name">
                                                <?php
                                                    $nama_parts = explode(' ', trim($crew['nama']));
                                                    $nama_utama = implode(' ', array_slice($nama_parts, 0, 2));
                                                    $nama_bawah = implode(' ', array_slice($nama_parts, 2));
                                                ?>
                                                <?= $nama_utama ?>
                                                <?php if (!empty($nama_bawah)): ?>
                                                    <small><?= $nama_bawah ?></small>
                                                <?php endif; ?>
                                            </div>
                                            <span class="id-card-role"><?= $crew['nama_jabatan'] ?? 'Jabatan Tidak Diketahui' ?></span>
                                        </span>
                                    </div>
                                    
                                    <div class="id-card-contact">
                                        <p><i class="far fa-calendar-alt"></i> 
                                            <?= !empty($crew['tanggal_lahir']) ? date('m/d/Y', strtotime($crew['tanggal_lahir'])) : ' Aktif' ?>
                                        </p>
                                        <p><i class="fas fa-phone"></i> <?= $crew['no_telp'] ?? 'Tidak Ada No. Telp' ?></p>
                                        <p><i class="fas fa-map-marker-alt"></i> 
                                            <?= !empty($crew['alamat']) ? substr($crew['alamat'], 0, 20) . '...' : 'Studio Najwa Record' ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-white text-center">Data kru belum tersedia.</p>
            <?php endif; ?>
        </div>
    </div>

    <?php include_once("partials/footer_portfolio.php"); ?>


    <div class="modal fade" id="crewDetailModal" tabindex="-1" aria-labelledby="crewDetailModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header modal-header-custom">
                    <h5 class="modal-title" id="crewDetailModalLabel">Detail Profil Kru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                
                <div class="modal-body">
                    <div class="modal-body-content">
                        <div class="modal-crew-photo">
                            <img id="modal_foto" src="" alt="Foto Kru">
                        </div>
                        
                        <div class="modal-crew-details">
                            <h3 id="modal_nama">Nama Kru</h3>
                            <h5 class="text-muted" id="modal_jabatan">Jabatan</h5>
                            <hr>
                            <p><strong><i class="fas fa-check me-2 text-success"></i> Status:</strong> <span id="modal_tgl_lahir"></span></p>
                            <p><strong><i class="fas fa-phone-alt me-2 text-success"></i> Telepon/WA:</strong> <span id="modal_telp"></span></p>
                            <p><strong><i class="fas fa-map-marker-alt me-2 text-primary"></i> Kantor:</strong> <span id="modal_alamat"></span></p>
                            <hr>
                            <p><strong>Deskripsi Singkat:</strong></p>
                            <p id="modal_deskripsi" class="fst-italic"></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <script>
        $(document).ready(function() {
            // Tangkap event ketika modal akan ditampilkan
            $('#crewDetailModal').on('show.bs.modal', function (event) {
                // Tombol/elemen yang memicu modal
                var button = $(event.relatedTarget); 
                
                // Ambil data dari atribut data-* kartu yang diklik
                var nama = button.data('nama');
                var jabatan = button.data('jabatan');
                var foto = button.data('foto');
                var telp = button.data('telp');
                var alamat = button.data('alamat');
                var tgl_lahir = button.data('tgl-lahir');
                var deskripsi = button.data('deskripsi');
                
                // Isi konten modal dengan data yang diambil
                var modal = $(this);
                modal.find('#modal_nama').text(nama);
                modal.find('#modal_jabatan').text(jabatan);
                modal.find('#modal_foto').attr('src', foto);
                modal.find('#modal_telp').text(telp);
                modal.find('#modal_alamat').text(alamat);
                modal.find('#modal_tgl_lahir').text(tgl_lahir);
                modal.find('#modal_deskripsi').text(deskripsi);
            });
        });
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>

</body>
</html>