  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
      <!-- Content Header (Page header) -->

      <!-- Main content -->
      <section class="content">
          <div class="container-fluid">
              <div class="row">
                  <div class="col-12">

                      <div class="card mt-3">
                          <div class="card-header d-flex align-items-center">
                              <h4 class="flex-grow-1 m-0 font-weight-bold">Data Anggaran</h4>
                              <?php if ($_SESSION['level'] == 'ADMIN') : ?>
                                  <a href="?page=tambah_anggaran" class="btn btn-primary">Tambah</a>
                              <?php endif; ?>
                          </div>
                          <!-- /.card-header -->
                          <style>
                              .small-td {
                                  width: 1%;
                                  white-space: nowrap;
                              }
                          </style>
                          <div class="card-body">
                              <table id="example2" class="table table-bordered table-striped">
                                  <thead>
                                      <tr>
                                          <th class="text-center">No</th>
                                          <th class="text-center small-td">Nama Klien</th>
                                          <th class="text-center">Total Anggaran</th>
                                          <th class="text-center">Detail Anggaran</th>
                                          <?php if ($_SESSION['level'] == 'ADMIN') : ?>
                                              <th class="text-center">Aksi</th>
                                          <?php endif; ?>
                                      </tr>
                                  </thead>
                                  <tbody>
                                      <?php
                                        // Inisialisasi nomor
                                        $no = 1;

                                        // Query untuk mengambil data dari tabel terkait
                                        $query = "
    SELECT 
        tb_anggaran.*,
        tb_klien.nama_lengkap,
        tb_pengajuan.id AS id_pengajuan,
        (
            (SELECT harga FROM tb_paket WHERE id = tb_pengajuan.dokumentasi)
        ) AS total_harga
    FROM 
        tb_anggaran
    INNER JOIN 
        tb_pengajuan 
    ON 
        tb_pengajuan.id = tb_anggaran.id_pengajuan
    INNER JOIN 
        tb_klien 
    ON 
        tb_pengajuan.id_klien = tb_klien.id";

                                        // Filter data jika user adalah 'KLIEN'
                                        if ($_SESSION['level'] == 'KLIEN') {
                                            $query .= " WHERE tb_klien.id = " . (int)$_SESSION['id_klien'];
                                        }

                                        // Jalankan query
                                        $result = $conn->query($query);

                                        // Periksa apakah query berhasil
                                        if ($result && $result->num_rows > 0) {
                                            // Loop untuk menampilkan data
                                            while ($row = $result->fetch_assoc()) :
                                        ?>
                                              <tr>
                                                  <!-- Kolom Nomor -->
                                                  <td class="text-center"><?= $no++ ?></td>

                                                  <!-- Kolom Nama Klien -->
                                                  <td class="text-center"><?= htmlspecialchars($row['nama_lengkap'], ENT_QUOTES, 'UTF-8') ?></td>

                                                  <!-- Kolom Total Harga -->
                                                  <td class="text-center">Rp. <?= number_format($row['total_harga'], 0, ",", "."); ?></td>

                                                  <!-- Kolom Detail -->
                                                  <td class="text-center">
                                                      <a href="?page=detail_anggaran&id=<?= (int)$row['id_pengajuan'] ?>">Lihat Detail</a>
                                                  </td>

                                                  <!-- Kolom Aksi (jika user adalah ADMIN) -->
                                                  <?php if ($_SESSION['level'] == 'ADMIN') : ?>
                                                      <td class="text-center small-td">
                                                          <a href="?page=edit_anggaran&id=<?= (int)$row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                                          <form action="?page=hapus_anggaran&id=<?= (int)$row['id'] ?>" method="POST" class="d-inline">
                                                              <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Hapus</button>
                                                          </form>
                                                      </td>
                                                  <?php endif; ?>
                                              </tr>
                                      <?php
                                            endwhile;
                                        } else {
                                            // Tampilkan pesan jika tidak ada data
                                            echo '<tr><td colspan="5" class="text-center">Data tidak ditemukan</td></tr>';
                                        }
                                        ?>
                                  </tbody>

                              </table>
                          </div>
                          <!-- /.card-body -->
                      </div>
                      <!-- /.card -->
                  </div>
                  <!-- /.col -->
              </div>
              <!-- /.row -->
          </div>
          <!-- /.container-fluid -->
      </section>
      <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <script>
      $(function() {
          $('#example2').DataTable({
              "paging": true,
              "lengthChange": true,
              "searching": true,
              "ordering": true,
              "info": true,
              "autoWidth": false,
              "responsive": true,
          });
      });
  </script>